/* getparam.h           typedefs and defines for getparams */

/* rcsid: @(#)getparam.h	@(#)getparam.h	1.3 10:20:48 5/26/94   EFC   */

#ifndef _GETPARAM_H
#define _GETPARAM_H 1.3

#ifdef REAL
#undef REAL
#endif
#ifdef BOOLEAN
#undef BOOLEAN
#endif
#ifdef SWITCH
#undef SWITCH
#endif

/* typedefs and defines that are needed */

#define COMMENT		'#'
#define DONE		':'

/* the parameter structure */

#define	INTEGER		0
#define	BOOLEAN		1
#define	CHARACTER	2
#define	STRING		3
#define	PROC		4
#define REAL		5
#define SWITCH		6
#define LONG		7

typedef	struct
{
	char		*name	   ;	/* parameter name	*/
	unsigned	type : 4   ;	/* variable type	*/
	int		*variable  ;	/* pointer to variable	*/
}
PARAM;

#ifdef __cplusplus
extern "C" {
#endif
#ifdef NO_PROTO
int get_parameters();
void show_params();
#else
int get_parameters(char* pfilename, PARAM *table, int tabsize);
void show_params(PARAM *tabp, int tabsize);
#endif

#ifdef __cplusplus
}
#endif

#endif
