static char rcsid[] = "@(#)getparam.c	1.3 10:21:01 5/26/94   EFC";

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "getparam.h"

/* #define DEBUG */

#define LINESIZE	120
#define NL		'\n'

typedef int (*PFI)();

#ifdef NO_PROTO
extern int stoi();
extern long stol();
#else
extern int stoi(char **);
extern long stol(char **);
#endif

void show_params();

static void raise(), skip_white(), skip_to_white();
static char *getword(), *setparam();
static PARAM *findparam();

extern double atof();
extern long atol();

#ifdef NO_PROTO
int get_parameters(paramfile, tabp, tabsize)
char *paramfile;
PARAM *tabp;
int tabsize;
#else
int get_parameters(char *paramfile, PARAM *tabp, int tabsize)
#endif
{
	char *index, parameter[33], line[LINESIZE+1];
	PARAM *parmp;
	static FILE *fin = (FILE *)NULL;

	
	if ( fin == NULL && (fin = fopen(paramfile,"r") ) == NULL)
	{

#ifndef SILENT
	     fprintf(stderr,"parameter file <%s> not found, defaults used.\n",
			paramfile);
#endif
		return( 0 );
	}

	/* read the new parameters */
	while ( fgets(line,LINESIZE,fin) )
	{
	        if ( strlen(line) < 1 )  /* previous read ended exactly on EOF */
	                 break;
	   
		/* remove final new-line */
		line[ strlen(line) - 1 ] = '\0';
#ifdef DEBUG
		fprintf(stderr,"%s\n", line);
#endif
		index = line;
		while ( *index && *index != NL )
		{
			skip_white( &index );
			if ( *index == '\0' || *index == COMMENT || *index == DONE)
					break;
			index = getword( index, parameter);
			parmp = findparam(parameter,tabp,tabsize);
			if (parmp == 0)
			{
#ifndef SILENT
				fprintf(stderr,
					"parameter <%s> not known, ignored.\n",
				parameter);
#endif
			}
			else
				index = setparam(parmp,index);
		}
		if ( *index == COMMENT )
				continue;
		if ( *index == DONE )		/* quit if DONE is found */
				break;
	}

	/* close the file if at the end, leave it open if there is more */
	/* (presumably, more would be read with a subsequent call) */
	if ( *index != DONE )
	{
		fclose( fin );
		fin = NULL;
		return( 1 );	/* success, and no more data */
	}
	else			
		return ( 2 );	/* there is more */

}

static PARAM *findparam( c, tabp, tabsize )
char *c;
PARAM *tabp;
int tabsize;
{
	/*	Return pointer to parameter table entry corresponding
	 *	to c (or 0 if c isn't in table).
	 */

	for(; --tabsize >= 0 ; tabp++ )
		if( strcmp(tabp->name,c) == 0 )
			return tabp;
	return 0;
}

static char *setparam( argp, linep )
PARAM	*argp;
char	*linep;
{
		/* Set a parameter.  argp points at the parameter table entry
		*  corresponding to *linep.  Return linep, updated to point
		*  past the parameter being set.
		*/

	++linep;

	switch( argp->type )
	{
	case INTEGER:
		*argp->variable = stoi( &linep );
		break;

	case BOOLEAN:
		*argp->variable = 1;
		break;

	case CHARACTER:
		skip_white( &linep );
		*argp->variable = *linep++;
		break;

	case STRING:
		skip_white( &linep );
		/* *(char **)argp->variable = linep; */
		*(char **)argp->variable = strdup(linep);
		linep = "";
		break;
	case PROC:
		(* (PFI)(argp->variable) )( linep );
		linep = "";
		break;
	case REAL:
		skip_white( &linep );
		*(double *)(argp->variable) = atof( linep );
 		/* skip past number */
		while ((*linep >= '0' && *linep <= '9') || *linep == '.' ||
			*linep == 'e' || *linep == 'E'  || *linep == '+' ||
			*linep == '-' )
				linep++;
		break;
	case SWITCH:
		*argp->variable = *argp->variable ? 0 : 1;
		break;
	case LONG:
		*(long *)argp->variable = stol( &linep );
		break;
	default:
		fprintf(stderr,"INTERNAL ERROR: BAD ARGUMENT TYPE\n");
		break;
	}
	return( linep );
}

void show_params( tabp, tabsize )
PARAM	*tabp;
int	tabsize;
{
	/*	Print the parameter table in the form:
	 *		<parameter name> <type>	(currently is <*variable>)
	 */

	fprintf(stderr,"The current setting of the parameters:\n");
	for(; --tabsize >= 0 ; tabp++ )
	{
		switch( tabp->type )
		{
		case INTEGER:
			fprintf(stderr,"%-32s <integer>   (currently is ",
				tabp->name);
			fprintf(stderr,"%-5d)\n",*(tabp->variable) );
			break;

		case BOOLEAN:
			fprintf(stderr,"%-32s <boolean>   (currently is ",
					tabp->name);
			fprintf(stderr,"%-5s)\n",*(tabp->variable)
						? "TRUE": "FALSE" );
			break;

		case CHARACTER:
			fprintf(stderr,"%-32s <character> (currently is ",
					tabp->name);
			fprintf(stderr,"%-5c)\n",*(tabp->variable) );
			break;

		case STRING:
			fprintf(stderr,"%-32s <string>    (currently is ",
					tabp->name);
			fprintf(stderr,"<%s>)\n",
					*(char **)tabp->variable);
			break;
		case REAL:
			fprintf(stderr,"%-32s <real>      (currently is ",
					tabp->name);
			fprintf(stderr,"%-5g)\n",*(double*)(tabp->variable) );
			break;

		case PROC:
			fprintf(stderr,"%-32s <function call>\n",
					tabp->name);
			break;
		case SWITCH:
			fprintf(stderr,"%-32s       (currently is  ",
					tabp->name);
			fprintf(stderr,"%-5s)\n",*(tabp->variable)
						? "TRUE": "FALSE" );
			break;
		case LONG:
			fprintf(stderr,"%-32s <long>    (currently is ",
					tabp->name);
			fprintf(stderr,"%-5ld)\n",*(long *)(tabp->variable) );
			break;

		}
	}
}


static void skip_white(line)
char **line;
{
	char *lptr;

	lptr = *line;

	while (  *lptr && isspace( *lptr ) )
			lptr++;

	*line = lptr;
}

static void skip_to_white(line)
char **line;
{
	char *lptr;

	lptr = *line;

	while ( *lptr && !isspace( *lptr ) )
			lptr++;

	*line = lptr;

}

static char *getword(buf1,buf2)
char *buf1, *buf2;
{

	/* skip white space */
	while( isspace( *buf1) && *buf1++ )
		;

	/* copy to white space or NULL */
	while ( isgraph( *buf1) && (*buf2++ = *buf1++) != '\0')
			;

	*buf2 = '\0';

	return( buf1 );
}

static void raise(word)
char *word;
{
	char *hold;

	hold = word;
	while ( *word )
	{
		*word = toupper( *word );
		word++;
	}
	
	/* point back to beginning of string */
	word = hold;


}

