/* table.h -- (srouted) routing table management */

/*
 *	$Id: table.h,v 1.1 1995/01/27 04:44:50 buhr Exp $
 */

#ifndef INC_TABLE_H
#define INC_TABLE_H

#ifndef DEFEXTS
#define EXTERN extern
#else
#define EXTERN
#endif DEFEXTS

#include <sys/time.h>
#include <sys/socket.h>
#include <net/if.h>

/*
 * Structure to store interface information
 */

struct tb_iface {
	char		tbif_dev[IFNAMSIZ];  /* device name */
	struct sockaddr	tbif_myaddr;	/* our address on interface */
	struct sockaddr	tbif_netmask;	/* subnet mask address */
	struct sockaddr	tbif_broadaddr;	/* broadcast address */
	struct sockaddr	tbif_dstaddr;	/* dest address for p-p links */
	short		tbif_metric;	/* total cost of interface */
	short		tbif_flags;
};

#define TBIFF_UP	0x0001		/* interface is up */
#define TBIFF_BROADCAST 0x0002		/* broadcast address valid */
#define TBIFF_LOOPBACK	0x0008		/* interface is loopback */
#define TBIFF_POINTOPOINT 0x0010	/* destination address valid */

#define TBIFF_USED	0x0020		/* this entry is used */

#define TB_IFACE_SIZE	16		/* interface table entries */

#define TBM_INFINITY	16

EXTERN struct tb_iface tb_iface[TB_IFACE_SIZE];


/*
 * Structure for a (srouted) routing table entry
 */

struct tb_route {
	struct sockaddr	tbrt_dst;	/* address of destination */
	struct sockaddr	tbrt_mask;	/* mask for this network */
	struct sockaddr	tbrt_gateway;	/* address of gateway */
	int		tbrt_iface;	/* interface of route (-1 if none) */
	int		tbrt_supernet;	/* supernet route (-1 if none) */
	short		tbrt_metric;	/* total cost to destination */
	short		tbrt_flags;
	time_t		tbrt_timer;	/* time of timeout/garb coll */
};

#define TBRTF_USED	0x0001		/* this route entry is in use */
#define TBRTF_CHANGED	0x0002		/* route change flag */
#define TBRTF_DIRECT	0x0004		/* directly connected interface */
#define TBRTF_DELETED	0x0008		/* entry has been deleted */
#define TBRTF_KEEP	0x0010		/* keep kernel's route on delete/kill */
#define TBRTF_KILLED	0x0020		/* entry has been killed */
#define TBRTF_HOST	0x0040		/* route is a host route */
#define TBRTF_TENTATIVE	0x0080		/* replace ASAP, ignoring metric */
#define TBRTF_SUBNET	0x0100		/* subnetted route */
#define TBRTF_SUPERNET	0x0200		/* net record for subnetted net */
#define TBRTF_TIMEOUT	0x0400		/* tbrt_timer contains timeout */
#define TBRTF_GARBCOLL	0x0800		/* tbrt_timer contains garbcoll */
#define TBRTF_TIMERON	(TBRTF_TIMEOUT|TBRTF_GARBCOLL)
#define TBRTF_DEFAULT	0x1000		/* this is the default route */

#define TB_ROUTE_SIZE	128		/* route table entries */

EXTERN struct tb_route tb_route[TB_ROUTE_SIZE];


/*
 *	Structure for analysis of a network address
 */

struct tb_address {
	struct sockaddr tba_addr;	/* original address */
	struct sockaddr tba_hostsa;	/* portless address, as sockaddr */
	struct sockaddr tba_subnetsa;	/* subnet, as sockaddr */
	struct sockaddr tba_netsa;	/* net, as sockaddr */
	struct sockaddr tba_supmasksa;	/* supernet mask, as sockaddr */
	short		tba_af;		/* address family */
	long		tba_network;	/* network number */
	long		tba_host;	/* host number */
	unsigned short	tba_port;	/* port number */
	long		tba_subnet;	/* subnet number */
	long		tba_netmask;	/* subnet mask */
	int		tba_iface;	/* interface assoc with address */
	short tba_flags;
};

#define TBAF_CLASSA	0x0001		/* network address class */
#define TBAF_CLASSB	0x0002
#define TBAF_CLASSC	0x0004
#define TBAF_CLASSABC	(TBAF_CLASSA|TBAF_CLASSB|TBAF_CLASSC)
#define TBAF_HOST	0x0008		/* is a single host */
#define	TBAF_SUBNET	0x0010		/* subnetted network */
#define TBAF_DEFAULT	0x0020		/* address is the default route */
#define TBAF_BROADCAST	0x0040		/* was a broadcast address */
#define TBAF_VALID	0x0080		/* address was valid */
#define TBAF_LOOPBACK	0x0100		/* address is loopback */

int tb_newiface( void );
int tb_newroute( void );
unsigned long int tb_satoip( struct sockaddr *sa );
void tb_iptosa( unsigned long int a, struct sockaddr *sa );
int tb_findroute( struct sockaddr *dst );
int tb_samehost( struct sockaddr *a1, struct sockaddr *a2 );
void tb_initroute( void );
short tb_rtmetric( struct sockaddr dst );
void tb_chkaddr( struct tb_address *a );
void tb_addroute( int route, struct tb_address *dest,
		 struct tb_address *gw, short cost );
void tb_delroute( int route, struct tb_address *dest );
void tb_killroute( int route );

#undef EXTERN

#endif INC_TABLE_H
