/* error.h -- error/notification/tracing support */

/*
 *	$Id: error.h,v 1.4 1995/02/17 02:11:19 buhr Exp $
 */

#ifndef INC_ERROR_H
#define INC_ERROR_H

#include "table.h"

#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <protocols/routed.h>

enum er_code {
   ERC_NOERROR,

/* input.c */
   ERCIN_BADFROM,
   ERCIN_VERS0,
   ERCIN_CZ,
   ERCIN_CZE,
   ERCIN_CMD0,
   ERCIN_UNKCMD,
   ERCIN_CMD34,
   ERCIN_CMD5,
   ERCIN_UNKAF,
   ERCIN_RESPPORT,
   ERCIN_RESPREMOTE,
   ERCIN_BADMETRIC,
   ERCIN_BADADDR,
   ERCIN_RTFULL,
   ERCIN_RTSUPER,

/* output.c */
   ERCOUT_SENDTO,
   ERCOUT_FULLOUT,
   ERCOUT_BADIFACE,

/* kernel.c */
   ERCKR_NOIPSOCK,
   ERCKR_IOCTL,
   ERCKR_IFFULL,
   ERCKR_XADDRT,
   ERCKR_XDELRT,

/* table.c */
   ERCTB_RTFULL,
   ERCTB_RTDUP,
   ERCTB_INVDEST,
   ERCTB_BADSUPER,

/* driver.c */
   ERCDR_SYNTAX,
   ERCDR_NOTROOT,
   ERCDR_BIGRIP,
   ERCDR_SELECT,
   ERCDR_ADDRSIZE,
   ERCDR_SOCKET,
   ERCDR_FCNTL,
   ERCDR_SSOPT,
   ERCDR_BIND,
   ERCDR_RECVFROM,
   ERCDR_GETSERV,

/* notification/tracing codes start here */
/* driver.c */
   ERCDR_USINGPORT,
   ERCDR_GETIFCONF,
   ERCDR_INITROUTE,
   ERCDR_GETTABLE,
   ERCDR_DUMPROUTE,
   ERCDR_SCHED,
   ERCDR_TIMEOUT,
   ERCDR_GOTINPUT,

/* input.c */
   ERCIN_GOTINPUT,
   ERCIN_IGNOREREQUEST,
   ERCIN_GOTREQUEST,
   ERCIN_REQWHOLE,
   ERCIN_REQENTRY,
   ERCIN_REQANSWER,
   ERCIN_GOTRESPONSE,
   ERCIN_RESENTRY,
   ERCIN_IGNOREHOST,
   ERCIN_RESADDED,
   ERCIN_HADROUTE,
   ERCIN_REPEATROUTE,
   ERCIN_RESDELETED,
   ERCIN_RESIGNORED,

/* output.c */
   ERCOUT_SENDING,
   ERCOUT_UPDATE,
   ERCOUT_SENDTABLE,
   ERCOUT_GETTABLE,

/* kernel.c */
   ERCKR_DELRT,
   ERCKR_ADDRT,

/* table.c */
   ERCTB_ADDEDSUPER,
   ERCTB_IFDEFAULT,
   ERCTB_ADDRT,
   ERCTB_DELRT,
   ERCTB_KEPTRT,
   ERCTB_KILLRT,

/* timer.c */
   ERCTM_SETTO,
   ERCTM_SETGC,
   ERCTM_KILL,
   ERCTM_TIMEOUT,
   ERCTM_GARBCOLL,
   ERCTM_NETO,
   ERCTM_NEGC,
   ERCTM_NENONE,

   ERC_LAST
};

#define warn0(code)		er_log( ERL_WARN, code ) 
#define warn1(code,a1)		er_log( ERL_WARN, code, (a1) ) 
#define warn2(code,a1,a2)	er_log( ERL_WARN, code, (a1), (a2) ) 
#define warn3(code,a1,a2,a3)	er_log( ERL_WARN, code, (a1), (a2), (a3) ) 
#define warn4(code,a1,a2,a3,a4)	er_log( ERL_WARN, code, (a1), (a2), (a3), (a4) ) 
#define warn5(code,a1,a2,a3,a4,a5)	er_log( ERL_WARN, code, (a1), (a2), (a3), (a4), (a5) ) 

#define weakwarn0(code)		er_log( ERL_WEAKWARN, code ) 
#define weakwarn1(code,a1)	er_log( ERL_WEAKWARN, code, (a1) ) 
#define weakwarn2(code,a1,a2)	er_log( ERL_WEAKWARN, code, (a1), (a2) ) 
#define weakwarn3(code,a1,a2,a3) er_log( ERL_WEAKWARN, code, (a1), (a2), (a3) ) 
#define weakwarn4(code,a1,a2,a3,a4) er_log( ERL_WEAKWARN, code, (a1), (a2), (a3), (a4) ) 
#define weakwarn5(code,a1,a2,a3,a4,a5)	er_log( ERL_WEAKWARN, code, (a1), (a2), (a3), (a4), (a5) ) 

#define die0(code)		er_log( ERL_DIE, code ) 
#define die1(code,a1)		er_log( ERL_DIE, code, (a1) ) 
#define die2(code,a1,a2)	er_log( ERL_DIE, code, (a1), (a2) ) 
#define die3(code,a1,a2,a3)	er_log( ERL_DIE, code, (a1), (a2), (a3) ) 
#define die4(code,a1,a2,a3,a4)	er_log( ERL_DIE, code, (a1), (a2), (a3), (a4) ) 
#define die5(code,a1,a2,a3,a4,a5)	er_log( ERL_DIE, code, (a1), (a2), (a3), (a4), (a5) ) 

#define note0(code)		er_log( ERL_NOTE, code ) 
#define note1(code,a1)		er_log( ERL_NOTE, code, (a1) ) 
#define note2(code,a1,a2)	er_log( ERL_NOTE, code, (a1), (a2) ) 
#define note3(code,a1,a2,a3)	er_log( ERL_NOTE, code, (a1), (a2), (a3) ) 
#define note4(code,a1,a2,a3,a4)	er_log( ERL_NOTE, code, (a1), (a2), (a3), (a4) ) 
#define note5(code,a1,a2,a3,a4,a5)	er_log( ERL_NOTE, code, (a1), (a2), (a3), (a4), (a5) ) 
#define note6(code,a1,a2,a3,a4,a5,a6)	er_log( ERL_NOTE, code, (a1), (a2), (a3), (a4), (a5), (a6) ) 

#define ERL_FORCE	(-1)
#define ERL_DIE		0
#define ERL_WARN	1
#define ERL_WEAKWARN	2
#define ERL_NOTE	3

void er_log( int level, enum er_code code, ... );
void er_dumproute( int rti );
void er_dumprip( struct rip *rip, int length, struct tb_address *from );
void er_dumpripe( struct rip *rip, int entry );
void er_tracechange( void );

#endif INC_ERROR_H
