/* Matt Hartley
   hartlw@rpi.edu
   http://www.rpi.edu/~hartlw

   26 Sep 97
   This is the remote reboot server

*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "menc.h"

void error(char *msg) {
  /* Print an error message and exit */
    perror(msg);
    exit(0);
}

int main(int argc, char *argv[])
{
   int sock, length, fromlen, n, rebootflag=0;
   struct sockaddr_in server;
   struct sockaddr_in from;
   FILE *passwdfile;
   char buf[MAXWORDLEN*MAXNETMULT*2];
   char clibuf[MAXWORDLEN*MAXNETMULT*2];
   char rootbuf[MAXWORDLEN*MAXNETMULT*2], passwdbuf[80], saltbuf[3];   
   char *temp;

   if (argc < 2) {
      fprintf(stderr, "Usage: %s port\n",argv[0]);
      exit(0);
   }
   
   sock=socket(AF_INET, SOCK_DGRAM, 0);
   if (sock < 0) error("Opening socket");
   length = sizeof(server);
   bzero(&server,length);
   server.sin_family=AF_INET;
   server.sin_addr.s_addr=INADDR_ANY;
   server.sin_port=htons(atoi(argv[1]));
   if (bind(sock,(struct sockaddr *)&server,length)<0) 
       error("binding");
   fromlen = sizeof(struct sockaddr_in);

   /* Read the root line from the passwd file and get only the root 
      crypted password into rootbuf, or read from the file specified
      by the user */
   if (!OVERRIDEROOT) {
     if (ENABLESHADOW) {
       passwdfile=fopen(SHADOWFILE,"r");
       fprintf(stderr,"SHADOW\n");
     }
     else
       passwdfile=fopen(PASSWDFILE,"r");
     fscanf(passwdfile,"%s",&passwdbuf);
     temp=strtok(passwdbuf,":");
     temp=strtok(NULL,":");
     bzero(saltbuf,3);
     strncpy(saltbuf,temp,2);
     CompleteEncode(temp,rootbuf);
   }
   else {
     passwdfile=fopen(EXTPASSWDFILE,"r");
     fscanf(passwdfile,"%c%c%s",&saltbuf[0],&saltbuf[1],&rootbuf);
   }
   fclose(passwdfile);
   
   while (1) {
     /* get the handshake and verify it */
     n=recvfrom(sock,buf,8,0,(struct sockaddr *)&from,&fromlen);
     if (n<0) error("recvfrom");
     if (strncmp(buf,"RRLOGIN",7)==0) {
       
       /* transmit salt */
       n=sendto(sock,saltbuf,strlen(saltbuf),0,
		(struct sockaddr *)&from,fromlen);
       if (n<0) error("sendto");
       
       /* now receive the crypted password */
       n = recvfrom(sock,buf,1024,0,(struct sockaddr *)&from,&fromlen);
       if (n<0) error("recvfrom");

       /* narrow down to just the crypted pasword */
       strncpy(clibuf,buf,n);

       /* compare with the root accounts' password on the server */
       if (strncmp(clibuf,rootbuf,n)==0) {
	 if (!IOLESS)
	   write(1,"PASSWORD ACCEPTED\n",18);
	 n=sendto(sock,"Accepted\n",9,0,
		  (struct sockaddr *)&from,fromlen);
	 rebootflag=1;
       }
       else {
	 if (!IOLESS)
	   write(1,"PASSWORD FAILED\n",16);
	 n=sendto(sock,"Denied\n",7,0,
		  (struct sockaddr *)&from,fromlen);
       }
       if (n < 0) error("sendto");
       
       /* Linux specific hard reboot */
       if (rebootflag==1) {
	 if (!IOLESS)
	   sync();
	 reboot(0xfee1dead,672274793,0x1234567);
       }
     }
   }
}






