/* Matt Hartley
   hartlw@rpi.edu
   http://www.rpi.edu/~hartlw

   25 Sep 97
   This is the remote reboot client

*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include "menc.h"

void error(char *msg) {
  /* Print an error message and exit */
    perror(msg);
    exit(0);
}

void main(int argc, char *argv[])
{
   int sock, length, n;
   struct sockaddr_in server, from;
   struct hostent *hp;
   char buffer2[256],saltbuf[3],*temp,*buffer;
   char sbuffer[MAXWORDLEN*MAXNETMULT*2];
   
   if (argc != 3) { printf("Usage: %s host port\n",argv[0]);
                    exit(1);
   }
   sock=socket(AF_INET, SOCK_DGRAM, 0);
   if (sock < 0) error("socket");

   server.sin_family = AF_INET;
   hp = gethostbyname(argv[1]);
   if (hp==0) error("Unknown host");

   bcopy((char *)hp->h_addr, 
        (char *)&server.sin_addr,
         hp->h_length);
   server.sin_port = htons(atoi(argv[2]));
   length=sizeof(struct sockaddr_in);

   /* Send a login handshake */
   n=sendto(sock,"RRLOGIN\n",8,0,&server,length);

   /* Get salt from server for root password */
   bzero(saltbuf,3);
   n=recvfrom(sock,saltbuf,3,0,&from,&length);
   if (n<0) error("recvfrom");     

   /* Get the root password from the user */
   printf("Connection established.\n");
   printf("Please enter the root password of the remote machine: ");
   bzero(buffer2,256);
   fgets(buffer2,255,stdin);

   /* crypt entry */
   buffer=strtok(buffer2,"\n");
   temp=crypt(buffer,saltbuf);
   
   /* matricize entry */
   CompleteEncode(temp,sbuffer);
   n=sendto(sock,sbuffer,
            strlen(sbuffer),0,&server,length);
   if (n < 0) error("Sendto");

   /* Receive messages */
   n = recvfrom(sock,buffer,256,0,&from, &length);
   if (n < 0) error("recvfrom");
   write(1,"Rebooting: ",11);
   write(1,buffer,n);
}





