#ifndef MENC_H
#define MENC_H
/* Matt Hartley
   hartlw@rpi.edu
   http://www.rpi.edu/~hartlw

   25 Sep 97
   This is the remote reboot server matrix encoding file.

*/

/* Max word length should be even */
#define MAXWORDLEN 64

/* Max multiplier is number of chars in an int per matrix loc */
#define MAXNETMULT 16

typedef struct NetEncWord {
  char data[2][MAXWORDLEN*MAXNETMULT];
} NetEncWord;

typedef struct EncodedWord {
  long int answer[2][MAXWORDLEN];
  int magicsplit;
} EncodedWord;

typedef struct OddWord {
  char first_word[MAXWORDLEN/2];
  char second_word[MAXWORDLEN/2];
  char pivot;
  int magicsplit;
} OddWord;

NetEncWord NetEncodeWord(EncodedWord ew) {
  long int i,j,k,l,m;
  NetEncWord response;

  response.data[0][0]='\0';
  response.data[1][0]='\0';
  
  for (k=0;k<2;k++) {
    m=0;
    for (i=0;i<ew.magicsplit;i++) {
      j=ew.answer[k][i];
      while (j>0) {
	l=j%10;
	j=j/10;
	response.data[k][m]=l+48;
	m++;
      }
    }
    response.data[k][m]='\0';
  }

  return(response);
}

EncodedWord EncodeWord(OddWord ow) {
  long int i,j,k,pivot; 
  long int w1[MAXWORDLEN];
  long int w2[MAXWORDLEN];
  long int m[MAXWORDLEN][MAXWORDLEN];
  EncodedWord response;

  pivot=ow.pivot;
  response.magicsplit=ow.magicsplit;

  /* initialize the answer sets */
  for (i=0;i<MAXWORDLEN;i++) {
    response.answer[0][i]=0;
    response.answer[1][i]=0;
  }

  /* put the first word in the matrix and multiply by the pivot */
  for (i=0;i<response.magicsplit;i++)
    w1[i]=ow.first_word[i]*pivot;
  
  /* put the second word in the matrix and multiply by the pivot */
  for (i=0;i<response.magicsplit;i++)
    w2[i]=ow.second_word[i]*pivot;
  
  /* fill in full matrix */
  for (i=0;i<response.magicsplit;i++) {
    for (j=0;j<response.magicsplit;j++) {
      m[i][j]=w1[j]*w2[i];
    }
  }
  
  /* sum columns for answer sets*/
  for (k=0;k<2;k++) {
    for (i=0;i<response.magicsplit;i++) {
      for (j=0;j<response.magicsplit;j++)
	if (k==0)
	  response.answer[k][i]=response.answer[k][i]+m[j][i];
	else
	  response.answer[k][i]=response.answer[k][i]+m[i][j];
    }
  }

  return(response);
}

OddWord SplitWord(char wholeword[MAXWORDLEN]) {
  char *marker;
  OddWord response;

  /* initialize word */
  strcpy(response.first_word,"\0");
  strcpy(response.second_word,"\0");

  if (strlen(wholeword)%2==0) {
    wholeword[strlen(wholeword)]='Z';
    wholeword[strlen(wholeword)+1]='\0';
  }

  /* find the middle of the word */
  response.magicsplit=(strlen(wholeword)-1)/2;
  marker=wholeword+response.magicsplit+1;

  /* setup return */
  strncpy(response.first_word,wholeword,response.magicsplit);
  response.first_word[response.magicsplit]='\0';
  strncpy(response.second_word,marker,response.magicsplit);
  response.second_word[response.magicsplit]='\0';
  response.pivot=wholeword[response.magicsplit];
  
  return(response);
}

void CompleteEncode(char wholeword[MAXWORDLEN],char finalout[MAXWORDLEN*MAXNETMULT*2]) {
  /* completely encode to a NetEncWord struct */
  NetEncWord nw;

  nw=NetEncodeWord(EncodeWord(SplitWord(wholeword)));
  strcpy(finalout,nw.data[0]);
  strcat(finalout,nw.data[1]);
}



#endif
