#ifndef CONFIG_H
#define CONFIG_H
/* Matt Hartley
   hartlw@rpi.edu
   http://www.rpi.edu/~hartlw

   26 Sep 97
   This is the remote reboot server configuration file.

   */

/* This defines the password file to open. If you have shadowing on your
system, change ENABLESHADOW to 1 and make sure the path is correct to your
shadow file */

#define ENABLESHADOW 0
#define PASSWDFILE "/etc/passwd"
#define SHADOWFILE "/etc/shadow"

/* This makes the daemon not log or sync on reboot in case you are concerned
about loss of I/O.  Set IOLESS to 0 if you want syncing and logging as default.
*/

#define IOLESS 1


/* This allows for use of a separate reboot password in a root-owned file 
and therefore the ENABLESHADOW section above is ignored.  This would be
the ideal option to use if your password file is not shadowed.

To correctly set this option, set OVERRIDEROOT to 1 and change 
EXTPASSWDFILE to the file location to store the encoded password. 

If you decide on this option, please run the rrgenpass program in the 
directory.
*/

#define OVERRIDEROOT 0
#define EXTPASSWDFILE "/root/.rrd"

#endif
