#include <varargs.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
#include <signal.h>
#include <string.h>

// announce our presence to log.h
#define AND_A_VOICE_BOOMS_OUT_THIS_IS_LOG_C_CALLING
#include "log.h"

// signal catchers
static void  catch_sigquit();
static void  catch_sigterm();
static void  catch_sigint();
void report_and_quit(char* msg);

int mode_is_syslog = 0;

void mode_syslog(char** argv)	// do system level logging
{
   mode_is_syslog = 1;
   signal(SIGQUIT, catch_sigquit);
   signal(SIGTERM, catch_sigterm);
   signal(SIGINT,  catch_sigint);
   openlog(*argv, LOG_PID, LOG_DAEMON); 
}

// basic log entry
void log(va_alist)
  va_dcl
{
   char*    format;
   va_list  args;
   char     str[10000];

   va_start(args);

   format = va_arg(args, char*);
   vsprintf(str, format, args);

   if(mode_is_syslog)
      syslog(LOG_DAEMON|LOG_INFO, str);
   else
      write(1, str, strlen(str));

   va_end(args);
}

// fatal error.  we do a perror here
void fatal(va_alist)
  va_dcl
{
   char*    format;
   va_list  args;
   char     str[10000];

   va_start(args);

   format = va_arg(args, char*);
   vsprintf(str, format, args);

   if(mode_is_syslog)
   {
      strcat(str,": %m\n"); /* emulate perror */
      syslog(LOG_DAEMON|LOG_ERR, str);
   }
   else
      perror(str);

   exit(-1);

   va_end(args);
}

// perror without exiting
void write_perror(va_alist)
  va_dcl
{
   char*    format;
   va_list  args;
   char     str[10000];

   va_start(args);

   format = va_arg(args, char*);
   vsprintf(str, format, args);

   if(mode_is_syslog)
   {
      strcat(str,": %m\n"); /* emulate perror */
      syslog(LOG_DAEMON|LOG_ERR, str);
   }
   else
      perror(str);

   va_end(args);
}

// regular error message
void write_error(va_alist)
  va_dcl
{
   int      is_fatal;
   char*    format;
   va_list  args;
   char     str[10000];

   va_start(args);

   is_fatal = va_arg(args, int);
   format = va_arg(args, char*);
   vsprintf(str, format, args);

   if(mode_is_syslog)
      syslog(LOG_DAEMON|LOG_ERR, str);
   else
      write(2, str, strlen(str));

   if(is_fatal)
      exit(-1);

   va_end(args);
}

static void  catch_sigquit()
{
   report_and_quit("Caught SIGQUIT, exiting");
}
static void  catch_sigterm()
{
   report_and_quit("Caught SIGTERM, exiting");
}
static void  catch_sigint()
{
   report_and_quit("Caught SIGINT, exiting");
}

void report_and_quit(char* msg)
{
   if(mode_is_syslog)
      syslog(LOG_DAEMON|LOG_WARNING, msg);
   else
      write(1, msg, strlen(msg));
   exit(0);
}
