/*
** OS-Specific code for Solaris 2.x for oidentd
** ultr0s <ultros@ojnk.net>
**
** Includes code blatantly stolen from pidentd's svr4.c and sunos5.c
**
** $Id: solaris2.c,v 1.6 2000/08/21 08:00:55 odin Exp $
*/

#include <config.h>

#define _KMEMUSER
#define _KERNEL

#define exit		kernel_exit
#define strsignal	kernel_strsignal

#include <unistd.h>
#include <string.h>
#include <stddef.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <netinet/in.h>

#include <stdio.h>
#include <kvm.h>
#include <nlist.h>
#include <math.h>
#include <stddef.h>
#include <sys/fcntl.h>
#include <sys/cred.h>
#include <sys/file.h>
#include <sys/stream.h>
#include <inet/common.h>
#include <inet/ip.h>

#include <oidentd.h>
#include <oidentd_util.h>

#define N_FANOUT 0

#if SOLARIS >=6
#define FANOUT_OFFSET(n)	(nl[N_FANOUT].n_value + \
				(n) * sizeof(icf_t) + offsetof(icf_t, icf_ipc))
#else
#define FANOUT_OFFSET(n)	(nl[N_FANOUT].n_value + (n) * sizeof(ipc_t *))
#endif

#undef exit
#undef strsignal

static int getbuf(long int addr, char *kbuf, int len);

static struct nlist nl[] = {
#if SOLARIS >= 6
	{ "ipc_tcp_conn_fanout" },
#else
	{ "ipc_tcp_fanout" },
#endif
	{ 0 },
};

static kvm_t *kd;

int get_user(int lport, int fport, const struct in_addr *laddr, const struct in_addr *faddr) {
	queue_t sqr;
	ipc_t ic, *icp;
	unsigned short uslp, usfp;
	unsigned int offset;
	file_t tf;
	unsigned long zero=0;
	u16 *ports;
	u32 *locaddr, *raddr;
	struct proc *procp;

	usfp = fport;
	uslp = lport;

	offset = usfp ^ uslp;
	offset ^= (unsigned)faddr->S_un.S_un_b.s_b4 ^ (offset >> 8);
	offset &= 0xff;

	if (!getbuf(FANOUT_OFFSET(offset), (char*) &icp, sizeof(ipc_t *)))
		return (-1);

#if SOLARIS >=6
	locaddr = (u32*) &ic.ipc_laddr;
	raddr = (u32*) &ic.ipc_faddr;
	ports = (u16*) &ic.ipc_ports;
#else
	locaddr = &ic.ipc_tcp_laddr;
	raddr = &ic.ipc_tcp_faddr;
	ports = (u16*) &ic.ipc_tcp_ports;
#endif
	
	while (icp) {
		if (!getbuf((unsigned long) icp, (char *) &ic, sizeof(ic)))
			return (-1);

		if (usfp == ports[0] && uslp == ports[1] &&
	 	 (memcmp(&laddr->s_addr, locaddr, 4) == 0 ||
	 	 memcmp(&zero, locaddr, 4) == 0) &&
	 	 memcmp(&faddr->s_addr, raddr, 4) == 0)
			break;

		icp = ic.ipc_hash_next;
	}

	if (!icp) {
		o_log(DPRI, "get_user: Port not found");
		return (-1);
	}

	if (!getbuf((unsigned long) ic.ipc_rq+offsetof(queue_t, q_stream),
	 (char*) &sqr.q_stream,
	 sizeof(sqr.q_stream)))
		return (-1);

	if (kvm_setproc(kd) != 0)
		return (-1);

	while((procp = kvm_nextproc(kd)) != NULL) {
		struct uf_entry files[NFPCHUNK];
		int nfiles = procp->p_user.u_nofiles;
		unsigned long addr = (unsigned long) procp->p_user.u_flist;

		while(nfiles > 0) {
			int nread = nfiles > NFPCHUNK ? NFPCHUNK : nfiles;
			int size = nread * sizeof(struct uf_entry);
			int i;
			struct file *last = 0;
			vnode_t vp;

			if(!getbuf(addr, (char *) &files[0], size))
				return (-1);

			for(i=0;i < nread; i++) {
				if(files[i].uf_ofile == 0 ||
				 files[i].uf_ofile == last)
					continue;

				if (!getbuf((unsigned long)
				 (last = files[i].uf_ofile),
				 (char*) &tf, sizeof(tf)))
					return (-1);

				if(!tf.f_vnode)
					continue;

				if(!getbuf((unsigned long) tf.f_vnode +
				 offsetof(vnode_t,v_stream),
				 (char *) &vp.v_stream,
				 sizeof(vp.v_stream)))
					return (-1);

				if(vp.v_stream == sqr.q_stream) {
					cred_t cr;
				
					if(!getbuf((unsigned long)
					 tf.f_cred + offsetof(cred_t, cr_ruid),
					 (char *) &cr.cr_ruid,
					 sizeof(cr.cr_ruid)))
						return (-1);
				
					return cr.cr_ruid;
				}
			}
			nfiles -= nread;
			addr += size;
		}
	}

	return (-1);
}

static int getbuf(long int addr, char *kbuf, int len) {
	int i, status = 0;
	
	for (i = 0 ; i < 5 ; i++) {
		status = kvm_read(kd, addr, kbuf, len);
		if (status >= 0)
			break;
	}

	if (status < 0)
		return (0);

	return (1);
}

int k_open(void) {
	kd = kvm_open(NULL, "/dev/mem", NULL, O_RDONLY, NULL);

	if (kd == NULL) {
		o_log(DPRI, "main: kvm_open");
		return (-1);
	}

	if (kvm_nlist(kd, nl) != 0) {
		o_log(DPRI, "main: kvm_nlist");
		return (-1);
	}

	return (0);
}
