/*
** oidentd - ojnk ident daemon
** Copyright (C) 1998,1999,2000 Ryan McCabe <odin@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
**
** $Id: oidentd_util.h,v 1.3 2000/08/22 01:43:50 odin Exp $
*/

#ifndef __OIDENTD_UTIL_H
#define __OIDENTD_UTIL_H

#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <netinet/in.h>

int o_log(int priority, char *fmt, ...);
int setup_listen(int listen_port, u_long listen_addr);
int drop_privs(uid_t new_uid, gid_t new_gid);
int get_udb_user(int lport, int fport, const struct in_addr *laddr, const struct in_addr *faddr, int sock);
int read_permline(FILE *f, u_char *rpbuf, int bufl);
ssize_t sockread(int fd, u_char *srbuf, size_t len);
int go_background(int ignore);
void *xmalloc(size_t size);
u_char *hostlookup(u_long lookup_addr, u_char *hostname, size_t len);
int get_port(const u_char *name);
int get_addr(const u_char *const hostname, u_long *g_addr);
int valid_number(const u_char *p);
char *xstrncpy(char *dest, const char *src, size_t n);

#ifndef HAVE_DPRINTF
int dprintf(int fd, char *fmt, ...);
#endif

#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t n, char const *fmt, ...);
#endif

#ifndef HAVE_VSNPRINTF
int vsnprintf(char *str, size_t n, char *fmt, va_list ap);
#endif

#endif
