/*
** oidentd - ojnk ident daemon
** Copyright (C) 1998,1999,2000 Ryan McCabe <odin@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
**
** $Id: linux.c,v 1.16 2000/08/22 06:07:48 odin Exp $
*/

#define _GNU_SOURCE
#include <config.h>

#include <oidentd.h>
#include <oidentd_util.h>
#include <oidentd_masq.h>
#include <stdlib.h>

#ifdef HAVE_LIBUDB
#	include <udb.h>
#endif

#ifdef MASQ_SUPPORT
	extern u_long proxy;
#endif

extern u_char *charset;
extern u_char *ret_os;
extern u_int flags;

/*
** Determine the owner of the connection.
*/

int get_user(int lport, int fport, const struct in_addr *laddr, const struct in_addr *faddr) {
	int uid, portl, portf;
	FILE *fp = NULL;
	u_char buf[1024];
	struct in_addr remote, local;

	lport = ntohs(lport);
	fport = ntohs(fport);

	fp = fopen(CFILE, "r");

	if (fp == NULL) {
		o_log(DPRI, "Error: fopen: %s: %s", CFILE, strerror(errno));
		return (-1);
	}

	fgets(buf, sizeof(buf) - 1, fp);

	/*
	** The line should never be longer than 1024 chars, so fgets should be OK.
	*/

	while (fgets(buf, sizeof(buf) - 1, fp)) {
		if (sscanf(buf, "%*d: %lX:%x %lX:%x %*x %*X:%*X %*x:%*X %*x %d %*d %*d",
			(long *) &local, &portl, (long *) &remote, &portf, &uid) == 5) {
#ifdef MASQ_SUPPORT
			if (flags & PROXY) {
				if (faddr->s_addr == proxy && remote.s_addr != proxy
					&& lport == portl && fport == portf) {
					fclose(fp);
					return (uid);
				} else if (local.s_addr == laddr->s_addr && portl == lport
					&& remote.s_addr == faddr->s_addr && portf == fport) {
						fclose(fp);

						return (uid);
				}
			} else if (local.s_addr == laddr->s_addr && portl == lport
				&& remote.s_addr == faddr->s_addr && portf == fport) {
				fclose(fp);

				return (uid);
			}
#else
			if (local.s_addr == laddr->s_addr && portl == lport
				&& remote.s_addr == faddr->s_addr && portf == fport) {
					fclose(fp);

					return (uid);
			}
#endif
		}
	}

	fclose(fp);
	return (-1);
}

#ifdef MASQ_SUPPORT

/*
** Handle a request to a host that's IP masquerading through us.
*/

int masq(int sock, int lport, int fport, const struct in_addr *remote) {
	FILE *fp = NULL;
	u_char buf[1024], proto[12];
	u_char os[24], user[16];
	int mport, lportm, fportm;
	int netfilter = 0, l1, l2, l3, l4, r1, r2, r3, r4;
	struct in_addr localm, remotem;

	fp = fopen(MASQFILE, "r");

	if (fp == NULL) {
		o_log(DPRI, "Error: %s: %s", MASQFILE, strerror(errno));

		fp = fopen(CONNTRACK, "r");

		if (fp == NULL) {
			o_log(DPRI, "Error: %s: %s", CONNTRACK, strerror(errno));
			return (-1);
		}

		netfilter = 1;
	}

	/* chomp */
	fgets(buf, sizeof(buf) - 1, fp);
	
	while (fgets(buf, sizeof(buf) - 1, fp)) {
		if (netfilter == 0) {
			if (sscanf(buf, "%11s %lX:%X %lX:%X %X %*X %*d %*d %*u", proto,
							(long *) &localm, &lportm, (long *) &remotem,
							&fportm, &mport) != 6)
				continue;
		} else {
			if (sscanf(buf, "%s %*d %*d ESTABLISHED src=%d.%d.%d.%d dst=%d.%d.%d.%d sport=%d dport=%d %*s %*s %*s dport=%d", proto, &l1, &l2, &l3, &l4,
					&r1, &r2, &r3, &r4, &lportm, &fportm, &mport) != 12)
				continue;

			localm.s_addr = l1 << 24 | l2 << 16 | l3 << 8 | l4;
			remotem.s_addr = r1 << 24 | r2 << 16 | r3 << 8 | r4;
		}

		if (!strcasecmp(proto, "tcp") &&
			mport == lport && fportm == fport &&
			(remotem.s_addr == ntohl(remote->s_addr) ||
			((flags & PROXY) && remote->s_addr == proxy && remotem.s_addr != proxy)))
		{
			if (flags & FWD) {
				struct in_addr fhost;

				fhost.s_addr = htonl(localm.s_addr);

				if (!fwd_request(sock, lport, lportm, fportm, &fhost))
					return (0);
				else {
					o_log(DPRI, "Forward to %s (%d %d) %s.",
						inet_ntoa(fhost), lportm, fportm,
						(flags & MASQ) ? "failed" : "not allowed");
				}
			}

			if (!find_entry(htonl(localm.s_addr), user, sizeof(user) - 1,
				os, sizeof(os) - 1)) {
					dprintf(sock, "%d , %d : USERID : %s%s%s : %s\r\n",
						lport, fport, OS(os),
						(charset != NULL ? " , " : ""),
						(charset != NULL ? charset : (u_char *) ""), user);

					o_log(PRIORITY,
						"[%s] (Masqueraded) Successful lookup: %d , %d : USERID : %s : %s",
						inet_ntoa(*remote), lport, fport, OS(os), user);

					fclose(fp);
					return (0);
			}
		}
	}
	
	fclose(fp);
	return (-1);
}

#endif /* masq */
