/*
** freebsd4.c - Ident lookup routines for FreeBSD 4.*
** Copyright (C) 2000 Ryan McCabe <odin@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
**
** $Id: freebsd4.c,v 1.2 2000/10/03 06:46:23 odin Exp $
*/

#define _GNU_SOURCE

#include <config.h>
#include <oidentd.h>
#include <stdlib.h>
#include <signal.h>
#include <oidentd_util.h>

#include <sys/filio.h>
#include <sys/ioccom.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/sysctl.h>
#include <sys/ucred.h>
#include <sys/uio.h>
#include <sys/utsname.h>

int get_user(int lport, int fport, const struct in_addr *laddr, const struct in_addr *faddr) {
	struct ucred ucred;
	struct sockaddr_in sin[2];
	int len;

	len = sizeof(struct ucred);

	memset(sin, 0, sizeof(sin));

	sin[0].sin_len = sizeof(struct sockaddr_in);
	sin[0].sin_family = AF_INET;
	sin[0].sin_port = lport;
	sin[0].sin_addr.s_addr = laddr->s_addr;

	sin[1].sin_len = sizeof(struct sockaddr_in);
	sin[1].sin_family = AF_INET;
	sin[1].sin_port = fport;
	sin[1].sin_addr.s_addr = faddr->s_addr;

	if (sysctlbyname("net.inet.tcp.getcred", &ucred, &len, sin, sizeof(sin)) == -1) {
		o_log(DPRI, "Error: sysctlbyname: %s", strerror(errno));
		return (-1);
	}

	return (ucred.cr_uid);
}
