
/* Net Update Client */

#define _HPUX_SOURCE

#include <sys/types.h>

#include <fcntl.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/utsname.h>
#include <unistd.h>

#if defined(__TURBOC__) || defined(__STDC__)
#define __ARGS(x)       x
#else
#define __ARGS(x)       ()
#define const
#endif

#include "/tcp/src/buildsaddr.h"

static void pexit __ARGS((const char *s));
static void doread __ARGS((int fd, char *buf, size_t cnt));
static void dowrite __ARGS((int fd, const char *buf, size_t cnt));

/*---------------------------------------------------------------------------*/

static void pexit(s)
const char *s;
{
  perror(s);
  exit(1);
}

/*---------------------------------------------------------------------------*/

static void doread(fd, buf, cnt)
int  fd;
char  *buf;
size_t cnt;
{

  char  *p = buf;
  int  n;

  while (cnt) {
    n = read(fd, p, cnt);
    if (n < 0) pexit("read");
    if (!n) {
      printf("read(): End of file\n");
      exit(1);
    }
    p += n;
    cnt -= n;
  }
}

/*---------------------------------------------------------------------------*/

static void dowrite(fd, buf, cnt)
int  fd;
const char *buf;
size_t cnt;
{

  const char * p = buf;
  int  n;

  while (cnt) {
    n = write(fd, p, cnt);
    if (n <= 0) pexit("write");
    p += n;
    cnt -= n;
  }
}

/*---------------------------------------------------------------------------*/

get_tcp_conn(host,serv)
char  *host, *serv;
{

  char  *client;
  char  buf[1024];
  char  filename[1024];
  int  addrlen;
  int  fdfile;
  int  fdsocket;
  int  filesize;
  int  i;
  int  net_filesize;
  int  net_i;
  struct sockaddr *addr;
  struct utsname utsbuf;

  alarm(6 * 3600);

  if (!(addr = build_sockaddr("unix:/tcp/.sockets/netcmd", &addrlen))) {
    printf("build_sockaddr(): Failed\n");
    exit(1);
  }
  fdsocket = socket(addr->sa_family, SOCK_STREAM, 0);
  if (fdsocket < 0) pexit("socket");

  if (connect(fdsocket, addr, addrlen)) pexit("connect");

  strcpy(buf, "binary\n");
  dowrite(fdsocket, buf, strlen(buf));

  sprintf(buf, "connect tcp %s %s\n", host,serv); 
  dowrite(fdsocket, buf, strlen(buf));

  return(fdsocket);
}

