
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __WDOG_H__

#define __WDOG_H__

#include <stdio.h>
#include "connect.h"

#define IPX_WDOG_PORT(c)		(ntohs(c->peer_addr.sipx_port)+1)
#define IPX_WDOG_POOL_INACTIVE		('?')
#define IPX_WDOG_SESSION_VALID		('Y')
#define IPX_WDOG_NO_VALID_SESSION	('N')

typedef
struct tagWatchDogPacket
{
	byte	cid		__attribute__((packed));
	byte	sign_char	__attribute__((packed));
} WatchDogPacket;

void ipx_wdog_dump(WatchDogPacket* buf,int size);
void ipx_wdog_fdump(FILE* file,WatchDogPacket* buf,int size);
void wdog_send(connection* c,char sign_char);
void handle_wdog(WatchDogPacket* pkt,int size,struct sockaddr_ipx* sipx);
void init_wdog();
void done_wdog();

#endif /* __WDOG_H__ */
