
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <ctype.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include "ipxncp.h"
#include "bindops.h"
#include "logging.h"
#include "config.h"
#include "util.h"

void daemonize()
{
	int fd,c;
	
	if ((c = fork()) > 0) exit(0);
  	if (c < 0)
  	{
		LPRINTF(LL_FATAL,("can't fork: %s\n",strerror(errno)));
		exit(1);
	}

	close(0);
	close(1);
	close(2);
	if ((fd = open("/dev/tty", O_RDWR)) >= 0) 
	{
		ioctl(fd, TIOCNOTTY, NULL);
		close(fd);
	}
}

char* strtoupper(char* s)
{
	char* p;
	for(p=s;*p;p++)
	{
		if (isalpha(*p)) *p=toupper(*p);
	}
	return s;
}

char* strtolower(char* s)
{
	char* p;
	for(p=s;*p;p++)
	{
		if (isalpha(*p)) *p=tolower(*p);
	}
	return s;
}

/*
-d<number>  debug log level (default=LL_INFO)
-p<number>  NCP service port (default=IPX_NCP_PORT (0x451))
-n<string>  server name (default=hostname)
*/

void parse_cmdline(int argc,char** argv)
{
	get_server_name(); /* read hostname */
	cmdline.log_level=LL_INFO;
	cmdline.ncp_port=htons(IPX_NCP_PORT);
	argc--;
	argv++;  
	for(;argc;argc--,argv++)
	{
		if (**argv!='-') {fprintf(stderr,"non-option parameters ignored\n");break;}
		switch(*++*argv)
		{
			case 'd':
			{
				if (sscanf(*argv+1,"%i",&cmdline.log_level)!=1)
				{
					fprintf(stderr,"invalid debug level (-d option)\n");
					exit(1);
				}
				break;
			}
			case 'p':
			{
				int pp;
				if (sscanf(*argv+1,"%i",&pp)!=1 || pp!=(unsigned short)pp)
				{
					fprintf(stderr,"invalid NCP port (-p option)\n");
					exit(1);
				}
				cmdline.ncp_port=htons(pp);
				break;
			}
			case 'n':
			{
				strncpy(server_name.name,*argv+1,sizeof(server_name.name)-1);
				server_name.name[sizeof(server_name.name)-1]=0;
				strtoupper(server_name.name);
				break;
			}
			default:
			{
				fprintf(stderr,"unknown option -%c\n",**argv);
				fprintf(stderr,
					"LinuxWare v0.9, (c) Ales Dryak, 1995\n"
					"Usage: lwared [-d<debug_level>] [-n<name>] [-p<port>]\n");
				exit(1);
			}
		}
	}
	set_desc_strings(); /* construct description strings */
#if 0
	printf("log level: %i, NCP port %04X, server name: %s\n",cmdline.log_level,ntohs(cmdline.ncp_port),SERVER_NAME);
#endif
}
