
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <signal.h>
#include "config.h"
#include "logging.h"
#include "signals.h"

volatile int terminate_request;
volatile int int_request;

void int_handler()
{
	signal(SIGINT,int_handler);
	int_request=1;
}

void terminate_handler()
{
	signal(SIGTERM,terminate_handler);
	terminate_request=SG_TERMINATE;
}

void hup_handler()
{
	signal(SIGHUP,hup_handler);
	terminate_request=SG_HANGUP;
}

void init_signals()
{
	terminate_request=SG_CONTINUE;
	signal(SIGTERM,terminate_handler);
	signal(SIGHUP,hup_handler);
	signal(SIGINT,int_handler);
	LPRINTF(LL_INFO,("signals initialized\n"));
}

void done_signals()
{
	signal(SIGTERM,SIG_DFL);
	signal(SIGHUP,SIG_DFL);
	signal(SIGINT,SIG_DFL);
	LPRINTF(LL_INFO,("signals shutdown\n"));
}
