
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include "ncpcomm.h"
#include "logging.h"
#include "config.h"

void ncp_get_date(struct ncp_date_info* nfo)
{
	time_t raw_time;
	struct tm* t;
	
	time(&raw_time);
	t=localtime(&raw_time);
	
	nfo->year=t->tm_year;
	nfo->month=t->tm_mon+1;
	nfo->day=t->tm_mday;
	nfo->hour=t->tm_hour;
	nfo->min=t->tm_min;
	nfo->sec=t->tm_sec;
	nfo->week_day=t->tm_wday;
}

ncp_date time2nw_date(time_t t)
{
	struct tm* lt;
	
	LPRINTF(LL_DEBUG,("localtime call\n"));
	lt=localtime(&t);
	return ((lt->tm_year-80)<<9)|((lt->tm_mon+1)<<5)|(lt->tm_mday);
}

ncp_time time2nw_time(time_t t)
{
	struct tm* lt;
	
	LPRINTF(LL_DEBUG,("localtime call\n"));
	lt=localtime(&t);
	return (lt->tm_hour<<11)|(lt->tm_min<<5)|(lt->tm_sec/2);
}

time_t nw2time(ncp_date nd,ncp_time nt)
{
	struct tm lt;
	
	lt.tm_sec=2*(nt&0x1F);
	lt.tm_min=(nt>>5)&0x3F;
	lt.tm_hour=(nt>>11);
	lt.tm_mday=nd&0x1F;
	lt.tm_mon=((nd>>5)&0x0F)-1;
	lt.tm_year=(nd>>9)+80;
	lt.tm_isdst=-1;
	
	LPRINTF(LL_DEBUG,("nw2time: date: %X time: %X res: %s\n",nd,nt,asctime(&lt)));
	
	return mktime(&lt);
}
