
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __NCP_H__

#define __NCP_H__

#include <stdio.h>
#include "ipxncp.h"
#include "connect.h"

void ncp_build_reply(struct ncp_reply* rpl,connection* c,int compl,int con);
void ncp_raw_send(struct sockaddr_ipx* sipx,char* buf,int size);
void ncp_compl_send(connection* c,int size,int compl,int con);
void ncp_send(connection* c,int size);
void ncp_send_failure(connection* c,int compl);
void ncp_send_ok(connection* c);

void ipx_ncp_open_dump(struct ncp_request* pkt,int size);
void ipx_ncp_close_dump(struct ncp_request* pkt,int size);
void ipx_ncp_request_dump(struct ncp_request* pkt,int size);
void ipx_ncp_reply_dump(struct ncp_reply* pkt,int size);
void ipx_ncp_dump(char* buf,int size);

void ipx_ncp_open_fdump(FILE* file,struct ncp_request* pkt,int size);
void ipx_ncp_close_fdump(FILE* file,struct ncp_request* pkt,int size);
void ipx_ncp_request_fdump(FILE* file,struct ncp_request* pkt,int size);
void ipx_ncp_reply_fdump(FILE* file,struct ncp_reply* pkt,int size);
void ipx_ncp_fdump(FILE* file,char* buf,int size);

void handle_ncp(char* buf,int size,struct sockaddr_ipx* sipx);

void init_ncp();
void done_ncp();

#endif /* __NCP_H__ */
