
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include "ncp.h"
#include "bcast.h"
#include "handlers.h"
#include "logging.h"
#include "msgops.h"

void ncp_handle_r21(int subfunc,int size,char* data,connection* c)
{
	switch(subfunc)
	{
	case 0: /* send broadcast message */
	{
		struct ncp_con_list* clist=(struct ncp_con_list*)data;
		struct ncp_message* msg;
		struct ncp_send_stat* sstat=(struct ncp_send_stat*)get_conn_buf(c);
		int cidx;
		
		msg=(struct ncp_message*)(data+sizeof(clist->len)+clist->len);
		sstat->len=clist->len;
		for(cidx=0;cidx<clist->len;cidx++)
		{
			int cid=clist->list[cidx];
			connection* cn;
			if (cid<MAX_CONNECT && (cn=get_conn(cid))->alloc &&
			    cn->logged_obj!=NULL && !cn->msg_hold)
			{

				/* notify station */
				bcast_send(cn,IPX_BCAST_MSG_NOTIFY);
				/* store msg */
				cn->msg=*msg;
				cn->msg_hold=1;
				cn->msg_timer=0;
				sstat->stat[cidx]=SSTAT_OK;
			}
			else
			{
				sstat->stat[cidx]=SSTAT_FAIL;
			}
		}
		ncp_send(c,sizeof(sstat->len)+sstat->len);
		return;
	}
	case 1: /* get broadcast message */
	{
		struct ncp_message* msg=(struct ncp_message*)get_conn_buf(c);
		
		if (c->alloc && c->msg_hold)
		{
			*msg=c->msg;
			c->msg_hold=0;
			ncp_send(c,sizeof(msg->len)+msg->len);
		}
		else
		{	
			ncp_send_failure(c,COMPL_FAILURE);
		}
		return;
	}
	default: LPRINTF(LL_FULL,("Unknown function (21,%d)\n",subfunc));
		ncp_send_failure(c,COMPL_FAILURE);
		return;	
	}
}

void send_broadcast_message(char* message)
{
	int cid;
	struct ncp_message msg;

	strncpy(msg.msg,message,sizeof(msg.msg)-1);
	msg.len=strlen(msg.msg);
	for(cid=1;cid<MAX_CONNECT;cid++)
	{
		connection* cn;
		if ((cn=get_conn(cid))->alloc &&
		    cn->logged_obj!=NULL && !cn->msg_hold)
		{
			/* notify station */
			bcast_send(cn,IPX_BCAST_MSG_NOTIFY);
			/* store msg */
			cn->msg=msg;
			cn->msg_hold=1;
			cn->msg_timer=0;
		}
	}
}

void notify_message_all()
{
	int cid;

	for(cid=1;cid<MAX_CONNECT;cid++)
	{
		connection* cn;
		if ((cn=get_conn(cid))->alloc && cn->msg_hold)
		{
			/* notify station */
			bcast_send(cn,IPX_BCAST_MSG_NOTIFY);
		}
	}
}
