
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __BINDERY_H__

#define __BINDERY_H__

#include "stdtypes.h"
#include "ipxkern.h"
#include "global.h"
#include "ncpcomm.h"
#include "lwpwd.h"

#define BTYPE_NONE	(0)
#define BTYPE_USER	(1)
#define BTYPE_SERVER	(4)
#define BTYPE_ALL	(0xFFFF)

#define BFLAG_DYNAMIC	(1)
#define BFLAG_STATIC	(0)

#define BPASS_ERROR	(0)
#define BPASS_OK	(1)
#define BPASS_NOLOGIN	(2)

typedef struct tag_object_property
{
	struct ncp_object_name name;
	union
	{
		char raw[0x80]		__attribute__ ((packed));
		char string[0x80]	__attribute__ ((packed));
		struct ncp_net_address
		{
			IPXNet net		__attribute__ ((packed));
			IPXNode node		__attribute__ ((packed));
			IPXPort port		__attribute__ ((packed));
		} net_address;
	} value;
	struct tag_object_property* next;
} object_property;

struct bindery_object
{
	dword id;
	word group_id;
	word type;
	struct ncp_object_name name;
	int (*password)(struct bindery_object* obj,lwpassword* passwd);
	byte flag;
	/* for dynamic objects e.g. servers */
	int timer; 
	object_property* prop_list;
};

typedef struct bind_list
{
	struct bindery_object obj;
	struct bind_list* next;
} bind_list;

object_property* prop_net_address(IPXNet network,IPXNode node,IPXPort port);
object_property* prop_full_name(char* fname);
object_property* prop_byname(struct bindery_object* obj,char* name);
void prop_add(struct bindery_object* obj,object_property* prop);
void prop_free(object_property* prop);
void bind_add(bind_list* obj);
bind_list* bind_alloc();
void bind_free(bind_list* bl);
int bind_remove(bind_list* bl);
bind_list* bind_first_that(int (*f)(bind_list*,void*),void* data);
int bpass_nologin(struct bindery_object* obj,lwpassword* passwd);

#endif /* __BINDERY_H__ */
