
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include <stdlib.h>
#include <string.h>
#include "bindery.h"
#include "logging.h"
#include "config.h"

static bind_list* bindery=NULL;

object_property* prop_net_address(IPXNet network,IPXNode node,IPXPort port)
{
	object_property* p;
	p=malloc(sizeof(*p));
	if (p==NULL) return NULL;
	strcpy(p->name.name,"NET_ADDRESS");
	p->value.net_address.net=network;
	ipx_assign_node(p->value.net_address.node,node);
	p->value.net_address.port=port;
	p->next=NULL;
	return p;
}

object_property* prop_full_name(char* fname)
{
	object_property* p;
	p=malloc(sizeof(*p));
	if (p==NULL) return NULL;
	strcpy(p->name.name,"IDENTIFICATION");
	strcpy(p->value.string,fname);
	p->next=NULL;
	return p;
}

object_property* prop_byname(struct bindery_object* obj,char* name)
{
	object_property* p;
	for(p=obj->prop_list;p!=NULL;p=p->next)
	{
		LPRINTF(LL_DEBUG,("prop_byname %s vs. %s\n",p->name.name,name));
		if (strcmp(p->name.name,name)==0) return p;
	}
	return NULL;
}

void prop_add(struct bindery_object* obj,object_property* prop)
{
	prop->next=obj->prop_list;
	obj->prop_list=prop;
}

void prop_free(object_property* prop)
{
	if (prop!=NULL)
	{
		/* recursive - stack overflow problem */
		prop_free(prop->next);
		free(prop);
	}
}

void bind_add(bind_list* obj)
{
	obj->next=bindery;
	bindery=obj;
}

bind_list* bind_alloc()
{
	bind_list* p;
	
	p=malloc(sizeof(*p));
	if (p==NULL) return NULL;
	p->next=NULL;
	p->obj.id=NOT_LOGGED;
	p->obj.group_id=NOBODY_GID;
	p->obj.type=BTYPE_NONE;
	p->obj.name.name[0]=0;
	p->obj.password=bpass_nologin;
	p->obj.flag=BFLAG_DYNAMIC;
	p->obj.timer=0;
	p->obj.prop_list=NULL;
	return p;
}

void bind_free(bind_list* bl)
{
	prop_free(bl->obj.prop_list);
	free(bl);
}

int bind_remove(bind_list* bl)
{
	bind_list** p;
	for(p=&bindery;(*p)!=NULL;p=&((*p)->next))
	{
		if ((*p)==bl)
		{
			*p=(*p)->next;
			bind_free(bl);
			return 1;
		}
	}
	return 0;
}

bind_list* bind_first_that(int (*f)(bind_list*,void*),void* data)
{
	bind_list* cur;
	for(cur=bindery;cur!=NULL;cur=cur->next)
	{
		if (f(cur,data)) return cur;
	}
	return NULL;
}

int bpass_nologin(struct bindery_object* obj,lwpassword* passwd)
{
	return BPASS_NOLOGIN;
}
