#include <string.h>
#include "nwcrypt.h"

static byte NWCryptTable[562]=
{
  0x4b,0x4c,0x07,0x08,0x00,0x08,0x06,0x04,0x0e,0x04,0x05,0x0c,0x01,0x07,0x0b,0x0f,
  0x0a,0x08,0x0f,0x08,0x0c,0x0c,0x09,0x04,0x01,0x0e,0x04,0x06,0x02,0x04,0x00,0x0a,
  0x0b,0x09,0x02,0x0f,0x0b,0x01,0x0d,0x02,0x01,0x09,0x05,0x0e,0x07,0x00,0x00,0x02,
  0x06,0x06,0x00,0x07,0x03,0x08,0x02,0x09,0x03,0x0f,0x07,0x0f,0x0c,0x0f,0x06,0x04,
  0x0a,0x00,0x02,0x03,0x0a,0x0b,0x0d,0x08,0x03,0x0a,0x01,0x07,0x0c,0x0f,0x01,0x08,
  0x09,0x0d,0x09,0x01,0x09,0x04,0x0e,0x04,0x0c,0x05,0x05,0x0c,0x08,0x0b,0x02,0x03,
  0x09,0x0e,0x07,0x07,0x06,0x09,0x0e,0x0f,0x0c,0x08,0x0d,0x01,0x0a,0x06,0x0e,0x0d,
  0x00,0x07,0x07,0x0a,0x00,0x01,0x0f,0x05,0x04,0x0b,0x07,0x0b,0x0e,0x0c,0x09,0x05,
  0x0d,0x01,0x0b,0x0d,0x01,0x03,0x05,0x0d,0x0e,0x06,0x03,0x00,0x0b,0x0b,0x0f,0x03,
  0x06,0x04,0x09,0x0d,0x0a,0x03,0x01,0x04,0x09,0x04,0x08,0x03,0x0b,0x0e,0x05,0x00,
  0x05,0x02,0x0c,0x0b,0x0d,0x05,0x0d,0x05,0x0d,0x02,0x0d,0x09,0x0a,0x0c,0x0a,0x00,
  0x0b,0x03,0x05,0x03,0x06,0x09,0x05,0x01,0x0e,0x0e,0x00,0x0e,0x08,0x02,0x0d,0x02,
  0x02,0x00,0x04,0x0f,0x08,0x05,0x09,0x06,0x08,0x06,0x0b,0x0a,0x0b,0x0f,0x00,0x07,
  0x02,0x08,0x0c,0x07,0x03,0x0a,0x01,0x04,0x02,0x05,0x0f,0x07,0x0a,0x0c,0x0e,0x05,
  0x09,0x03,0x0e,0x07,0x01,0x02,0x0e,0x01,0x0f,0x04,0x0a,0x06,0x0c,0x06,0x0f,0x04,
  0x03,0x00,0x0c,0x00,0x03,0x06,0x0f,0x08,0x07,0x0b,0x02,0x0d,0x0c,0x06,0x0a,0x0a,
  0x08,0x0d,0x48,0x93,0x46,0x67,0x98,0x3d,0xe6,0x8d,0xb7,0x10,0x7a,0x26,0x5a,0xb9,
  0xb1,0x35,0x6b,0x0f,0xd5,0x70,0xae,0xfb,0xad,0x11,0xf4,0x47,0xdc,0xa7,0xec,0xcf,
  0x50,0xc0,0x0f,0x08,0x05,0x07,0x0c,0x02,0x0e,0x09,0x00,0x01,0x06,0x0d,0x03,0x04,
  0x0b,0x0a,0x02,0x0c,0x0e,0x06,0x0f,0x00,0x01,0x08,0x0d,0x03,0x0a,0x04,0x09,0x0b,
  0x05,0x07,0x05,0x02,0x09,0x0f,0x0c,0x04,0x0d,0x00,0x0e,0x0a,0x06,0x08,0x0b,0x01,
  0x03,0x07,0x0f,0x0d,0x02,0x06,0x07,0x08,0x05,0x09,0x00,0x04,0x0c,0x03,0x01,0x0a,
  0x0b,0x0e,0x05,0x0e,0x02,0x0b,0x0d,0x0a,0x07,0x00,0x08,0x06,0x04,0x01,0x0f,0x0c,
  0x03,0x09,0x08,0x02,0x0f,0x0a,0x05,0x09,0x06,0x0c,0x00,0x0b,0x01,0x0d,0x07,0x03,
  0x04,0x0e,0x0e,0x08,0x00,0x09,0x04,0x0b,0x02,0x07,0x0c,0x03,0x0a,0x05,0x0d,0x01,
  0x06,0x0f,0x01,0x04,0x08,0x0a,0x0d,0x0b,0x07,0x0e,0x05,0x0f,0x03,0x09,0x00,0x02,
  0x06,0x0c,0x05,0x03,0x0c,0x08,0x0b,0x02,0x0e,0x0a,0x04,0x01,0x0d,0x00,0x06,0x07,
  0x0f,0x09,0x06,0x00,0x0b,0x0e,0x0d,0x04,0x0c,0x0f,0x07,0x02,0x08,0x0a,0x01,0x05,
  0x03,0x09,0x0b,0x05,0x0a,0x0e,0x0f,0x01,0x0c,0x00,0x06,0x04,0x02,0x09,0x03,0x0d,
  0x07,0x08,0x07,0x02,0x0a,0x00,0x0e,0x08,0x0f,0x04,0x0c,0x0b,0x09,0x01,0x05,0x0d,
  0x03,0x06,0x07,0x04,0x0f,0x09,0x05,0x01,0x0c,0x0b,0x00,0x03,0x08,0x0e,0x02,0x0a,
  0x06,0x0d,0x09,0x04,0x08,0x00,0x0a,0x03,0x01,0x0c,0x05,0x0f,0x07,0x02,0x0b,0x0e,
  0x06,0x0d,0x09,0x05,0x04,0x07,0x0e,0x08,0x03,0x01,0x0d,0x0b,0x0c,0x02,0x00,0x0f,
  0x06,0x0a,0x09,0x0a,0x0b,0x0d,0x05,0x03,0x0f,0x00,0x01,0x0c,0x08,0x07,0x06,0x04,
  0x0e,0x02,0x03,0x0e,0x0f,0x02,0x0d,0x0c,0x04,0x05,0x09,0x06,0x00,0x01,0x0b,0x07,
  0x0a,0x08,
};

static void p431(byte* dest,byte* src)
{
  byte cl,dl,dh;
  word ax,si,i;
  byte* p;

  cl=0;
  for(ax=0;ax<2;ax++)
  {
    for(si=0,p=src;si<0x20;si++,p++)
    {
      dl=cl;
      dl=src[(dl+si)&0x1f];
      dl-=NWCryptTable[0x102+si];
      dh=cl+*p;
      dl^=dh;
      cl+=dl;
      *p=dl;
    }
  }
  for(p=dest;p<dest+0x10;*p++=0) {}
  for(i=0;i<0x20;i++)
  {
    cl=NWCryptTable[0x2+src[i]];
    if (i&1) cl<<=4;
    dest[i>>1]|=cl;
  }
}

void nwc_hash(byte* dest,byte* src,word len,byte* oid)
{
  byte* p;
  byte* q;
  byte* r;
  word si;
  byte work[0x20];

  p=src+(len)-1;
  for(;;)
  {
    if ((len)==0) break;
    if ((*p)!=0) break;
    p--;
    (len)--;
  }
  for(p=work;p<work+0x20;*p++=0) {}
  for(p=src;(len)>=0x20;(len)-=0x20)
  {
     for(si=0;si<0x20;si++)
     {
       work[si]^=*p++;
     }
  }
  if ((len)>0)
  {
     q=p+(len);
     r=p;
     for(si=0;si<0x20;si++)
     {
       if (r==q)
       {
	 r=p;
	 work[si]^=NWCryptTable[0x102+si];
       }
       else
       {
	 work[si]^=*r++;
       }
     }
  }
  for(si=0;si<0x20;si++)
  {
    work[si]^=oid[si&3];
  }
  p431(dest,work);
}

void nwc_encrypt(byte* dest,byte* src,byte* key)
{
  byte* p;
  byte work[0x20];
  word si;

  nwc_hash(work,src,0x10,key);
  nwc_hash(work+0x10,src,0x10,key+4);
  for(si=0,p=work+0x1F;si<0x10;si++)
  {
    work[si]^=*p--;
  }
  for(si=0,p=work+0xF;si<0x8;si++)
  {
    dest[si]=work[si]^*p--;
  }
}

void nwc_crypt(byte* key,char* passwd,byte* oid)
{
  byte work[0x10];

  nwc_hash(work,passwd,strlen(passwd),oid);
  nwc_encrypt(key,work,key);
}
