#include "ipxbridge.h"

#include <stdio.h>

  // Network includes..
#include <sys/socket.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <sys/ioctl.h>

#include <fcntl.h>

#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <syslog.h>

#ifndef MAX
#define MAX(a, b)	((a) > (b) ? (a) : (b))
#endif

#define __BE_DAEMON__
// #define __DEBUG_ADD__
// #define __DEBUG_SEND__
// #define __DEBUG_SOCKET__
// #define __DEBUG_PACKETS__
// #define __DEBUG_TREE__

// #define __SYSLOG__

printHex(char *s, int len)
{
        int i;

        for(i = 0; i < len; i++) {
                printf("%02x ", ((unsigned char) s[i]) & 0xFF);
                if(i && (i % 25 == 0))
                	putchar('\n');
	}
}

sprintHex(char *buf, char *s, int len)
{
  int i;

  for(i = 0; i < len; i++)
    sprintf(buf, "%02x ", ((unsigned char) s[i]) & 0xFF);
}

struct packet {
	unsigned short	len;
	char		buf[ETH_FRAME_LEN];
} p;

struct ethAddr {    // Like binary tree.

	struct ethAddr	*left;
	struct ethAddr  *right;
     
	unsigned char	    hwAddr[ETH_ALEN];
	struct sockaddr_pkt saddr;	// interface to send.

	int		age;    // for future use
} firstAddr;

struct sockaddr_pkt from;

struct ethAddr *find( unsigned char *hw, struct ethAddr *addr ) {

  while ( addr->age ) {
    if ( memcmp( addr->hwAddr, hw, sizeof(addr->hwAddr) ) < 0 )    // to left
      if ( addr->left ) {
        addr = addr->left;
        continue;
      }
      else { 
#ifdef __DEBUG_TREE__
        printf("\nCould not find in the tree:\n");
        printf("MAC: ");
        printHex( addr->hwAddr, ETH_ALEN );
        printf( " interface: %s\n\n", addr->saddr.spkt_device );
#endif
        return 0;
      }
            
    if ( memcmp( addr->hwAddr, hw, sizeof(addr->hwAddr) ) > 0 )    // to right
      if ( addr->right ) {
        addr = addr->right;
        continue;
      }
      else {
#ifdef __DEBUG_TREE__
        printf("\nCould not find in the tree:\n");
        printf("MAC: ");
        printHex( addr->hwAddr, ETH_ALEN );
        printf( " interface: %s\n\n", addr->saddr.spkt_device );
#endif
        return 0;
      }
        
    return addr;
  }
}


#ifdef __DEBUG_ADD__
void printTree( struct ethAddr *addr ) {
  if ( addr->age ) {
    printf("\nTree node, interface: %s MAC: ", addr->saddr.spkt_device );
    printHex( addr->hwAddr, ETH_ALEN );
    printf("\n");
    if (addr->left)
      printTree( addr->left );
    if (addr->right)
      printTree( addr->right );
  }
}
#endif

void addSrc( unsigned char *hw, struct ethAddr *addr) {  // Depend on global 'from' variable.

  while ( addr->age ) {
    if ( memcmp( addr->hwAddr, hw, sizeof(addr->hwAddr) ) < 0 )    // to left
      if ( addr->left ) {
        addr = addr->left;
        continue;
      }
      else {
        addr->left = malloc( sizeof(firstAddr) );
        addr = addr->left;
        addr->age = 0;
        continue;
      }
    
    if ( memcmp( addr->hwAddr, hw, sizeof(addr->hwAddr) ) > 0 )    // to right
      if ( addr->right ) {
        addr = addr->right;
        continue;
      }
      else {
        addr->right = malloc( sizeof(firstAddr) );
        addr = addr->right;
        addr->age = 0;
        continue;
      }
    // Allready exists.
#ifdef __DEBUG_TREE__
    printf("\nadd() Address was found in the tree...\n");
    printf("MAC: ");
    printHex( addr->hwAddr, ETH_ALEN );
    printf( " interface: %s\n\n", addr->saddr.spkt_device );
#endif
    return;
  }
  
    // fill the addr.
  memcpy( &(addr->hwAddr), hw, sizeof(addr->hwAddr) );
  memcpy( &(addr->saddr), &from, sizeof(from) );
  addr->age = 1;

#ifdef __DEBUG_ADD__
  printf("\nadd() Adding to tree.\n");
  printf("MAC: ");
  printHex( hw, ETH_ALEN );
  printf( " interface: %s\n\n", from.spkt_device );
  printTree( &firstAddr );
  fflush( stdout );
#endif
#ifdef __SYSLOG__

  syslog( LOG_NOTICE, "Adding to tree: %s, MAC: %02x:%02x:%02x:%02x:%02x:%02x.", 
          from.spkt_device,
          hw[0],
          hw[1],
          hw[2],
          hw[3],
          hw[4],
          hw[5] );
#endif
}


struct sockaddr_pkt * getAddr() {    // Depend on global 'p' and 'from' variable.
    struct ethAddr *ret;
    unsigned char *dstAddr;
    unsigned char *srcAddr;

	dstAddr = (unsigned char *) p.buf;
	srcAddr = (unsigned char *) p.buf + ETH_ALEN;

    addSrc( srcAddr, &firstAddr);    // Add srs to tree if non exists.

    ret = find( dstAddr, &firstAddr );

    if ( ret )
      return &(ret->saddr);
return NULL;
}


void RecvEther(int sd);

int sock802_2, sock802_3, sockIpx, sockSnap;

int sendSock;

main() {
   fd_set sds;
   struct ifreq ifr;
   int max, max2, no;

   int i;

   firstAddr.age = 0;    // tree root is empty.
   // Fill sockaddrs for local interfaces.

   readConfig();

   sock802_2 = socket(AF_INET, SOCK_PACKET, htons(ETH_P_802_2));
   sock802_3 = socket(AF_INET, SOCK_PACKET, htons(ETH_P_802_3));
   sockIpx = socket(AF_INET, SOCK_PACKET, htons(ETH_P_IPX));
   sockSnap = socket(AF_INET, SOCK_PACKET, htons(ETH_P_SNAP));

   sendSock = socket(AF_INET, SOCK_PACKET, htons(ETH_P_802_2));
    


   if(fcntl(sock802_2, F_SETFL, FNDELAY) < 0)
      perror("fcntl() for sock802_2");

   if(fcntl(sock802_3, F_SETFL, FNDELAY) < 0)
      perror("fcntl() for sock802_3");

   if(fcntl(sockIpx, F_SETFL, FNDELAY) < 0)
      perror("fcntl() for sockIpx");

   if(fcntl(sockSnap, F_SETFL, FNDELAY) < 0)
      perror("fcntl() for sockSnap");

   for( i=0 ; i < howManyInterfaces; i++ ) {
//    ((sockaddr *)&interfaces[i])->sa_family = AF_INET;

        // Let set IFF_PROMISC mode
      strcpy( ifr.ifr_name, interfaces[i].spkt_device );

      if(ioctl(sendSock, SIOCGIFFLAGS, &ifr) < 0) {
         perror("SIOCGIFFLAGS");
         return;
      }

      ifr.ifr_flags |= IFF_PROMISC;
      if(ioctl(sendSock, SIOCSIFFLAGS, &ifr) < 0)
         perror("SIOCSIFFLAGS");
   }
    


   printf("Sockets opened go to recieve loop\n\n");

#ifdef __BE_DAEMON__
   if ( daemon(0, 0) )
      exit( 0 );
#endif
  
  for(;;) {
  
	memset(&from, '\0', sizeof(from));
	do {
		FD_ZERO(&sds);
		FD_SET(sock802_2, &sds);
		FD_SET(sock802_3, &sds);
		FD_SET(sockIpx, &sds);
		FD_SET(sockSnap, &sds);
		max  = MAX(sock802_2, sock802_3);
		max2 = MAX(sockIpx, sockSnap);
		max  = MAX(max, max2);
	} while((no = select(max + 1, &sds, (fd_set *) 0, (fd_set *) 0,
		                 (struct timeval *) 0)) < 0 && errno == EINTR);

	/* errno != EINTR */
	if(no <= 0) {
		perror("select()");
        continue;
	}

	if(FD_ISSET(sock802_2, &sds)) {
#ifdef __DEBUG_SOCKET__
		printf("\nReceived from socket: 802.2\n");
#endif
		RecvEther(sock802_2);
	}
	if(FD_ISSET(sock802_3, &sds)) {
#ifdef __DEBUG_SOCKET__
		printf("\nReceived from socket: 802.3\n");
#endif
		RecvEther(sock802_3);
	}
	if(FD_ISSET(sockIpx, &sds)) {
#ifdef __DEBUG_SOCKET__
		printf("\nReceived from socket: IPX\n");
#endif
		RecvEther(sockIpx);
	}
	if(FD_ISSET(sockSnap, &sds)) {
#ifdef __DEBUG_SOCKET__
		printf("\nReceived from socket: SNAP\n");
#endif
		RecvEther(sockSnap);
	}
  }
}


/*******************************************************************************
Send IPX-Packet.
*******************************************************************************/
sendEther( struct sockaddr_pkt *to )
{
#ifdef __DEBUG_SEND__
    printf("sendEther to: %s, from MAC: ", to->spkt_device );
    printHex((unsigned char *) p.buf + ETH_ALEN, ETH_ALEN );
    printf("-to- ");
    printHex((unsigned char *) p.buf, ETH_ALEN );
    printf("\n");
#endif
  if( sendto(sendSock, p.buf, p.len, 0, (struct sockaddr *)to, sizeof(struct sockaddr_pkt)) != p.len )
    perror("sendto()");
}

/*******************************************************************************
Get frames with IPX-Packets from ethernet, forward them.
*******************************************************************************/
void RecvEther(int sd)
{
    int		fromLen;
    int     frameLen;
    int     i;

	struct sockaddr_pkt	*addrTo;

	fromLen = sizeof(from);

	frameLen = recvfrom(sd, p.buf, ETH_FRAME_LEN, 0, (struct sockaddr *)&from, &fromLen);
	if(frameLen <= 0) {
		if(frameLen < 0)
			perror("recvfrom(eth)");
		else
			printf("EOF");
		return;
	}
	p.len = frameLen;
    
#ifdef __DEBUG_PACKETS__
    printf("Iterface: %s, from MAC: ", from.spkt_device );
    printHex((unsigned char *) p.buf + ETH_ALEN, ETH_ALEN );
    printf("-to- ");
    printHex((unsigned char *) p.buf, ETH_ALEN );
    printf("\n");
#endif
    addrTo = getAddr();

    if ( addrTo ) {
#ifdef __DEBUG_PACKETS__
      printf( "Found addrTo: %s\n", addrTo->spkt_device );
#endif
      if ( memcmp(addrTo->spkt_device, from.spkt_device, sizeof(from.spkt_device)) ) {    // Not the same segment
        sendEther( addrTo );
      } else {
#ifdef __DEBUG_PACKETS__
        printf("Packet to the same segment. Do nothing.\n");
#else
;
#endif
      }
    }
    else {
#ifdef __DEBUG_PACKETS__
      printf( "addrTo not found, sending to all other interfaces...\n" );
#endif
      for( i=0;i<howManyInterfaces;i++ )
        if ( memcmp(from.spkt_device, interfaces[i].spkt_device, sizeof(from.spkt_device)) )
          sendEther( &interfaces[i] );
    }
}
