#include "ipxbridge.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#define MAXLINE 512

   // Globals
int howManyInterfaces;
struct sockaddr_pkt *interfaces;

removeNoise( char *line )
{
   int last,i;
   for( last = -1, i = 0; line[i]; i++ )
      switch( line[i] ) {
         case '\n':
         case '\r':
         case ' ':
	 case 9:
            if ( last == -1 )
               last = i;
            break;
         default:
            if ( last != -1 ) {
               line[ last ] = line[ i ];
               last++;
            }
      }
   
   if( last != -1 )
      line[ last ] = 0; 
}

readConfig()
{
   FILE *fp;
   char line[MAXLINE];
   int i;
   int allreadyPresent;

   if(!(fp = fopen( CONFIG_FILE, "r"))) {
      perror( CONFIG_FILE );
      exit( 1 );
   }

   howManyInterfaces = 0;
   interfaces = 0;

   while( fgets(line, MAXLINE, fp) ) {
      removeNoise( line );
      if ( strlen(line) ) 
         if ( *line != '#' ) {
            printf( "Adding interface: %s\n", line );

            // Test if it's allready present
            allreadyPresent = 0;
            for( i = 0; i < howManyInterfaces; i++ )
               if ( !strcmp(interfaces[i].spkt_device, line) ) {
                  allreadyPresent = 1;
                  break;
               }

            if ( allreadyPresent ) {
               fprintf( stderr, "\nConfig file error, interface %s allready added\n", line );
               continue;
            }

            if ( strlen(line) > sizeof(interfaces[0].spkt_device) ) {
               fprintf( stderr, "\nToo long interface name: %s, skipped\n", line );
               continue;
            }

            interfaces = realloc( interfaces, (howManyInterfaces + 1) * sizeof( struct sockaddr_pkt ) );

            memset( &(interfaces[ howManyInterfaces]), '\0', sizeof(interfaces[0]) );
            strcpy( interfaces[howManyInterfaces].spkt_device, line );
            howManyInterfaces++;
         }
   }

   if ( !howManyInterfaces ) {
      fprintf( stderr, "\n\nError: No one interface in the config file.\n\n" );
      exit( -1 );
   }

   if ( howManyInterfaces < 2 ) {
      fprintf( stderr, "\n\nError: Only one interfave in the config file.\n\n" );
      exit( -1 );
   }
}
