/*************************************************************************/
/*                  VChat interactive IP-level chat system               */
/*-----------------------------------------------------------------------*/
/*  (c) '93/'94 by Andreas S. Wetzel (mickey@deadline.bln.sub.org)       */
/*                 All rights reserverd.                                 */ 
/*-----------------------------------------------------------------------*/
/* See the file COPYRIGHT in the top level directory of VChat for        */
/* copyright notices and further disclaimers.                            */ 
/*************************************************************************/

/****************** Prototypes ******************/

/** vserver.c **/

void	main(int argc, char *argv[]);
void	handle_cmd(int cmd, struct client_data *cl, char *data);

/** commands.c **/

void	signon(struct client_data *ptr);
void	signoff(struct client_data *ptr);
void	err_signoff(struct client_data *ptr);
void	chnick(struct client_data *ptr, char *dat);
void	chchan(struct client_data *ptr, char *dat);
void	prvmsg(struct client_data *ptr, char *dat);
void	pubmsg(struct client_data *ptr, char *dat);
void	invite(struct client_data *ptr, char *dat);
void	snd_id(struct client_data *ptr);
void	ulist(struct client_data *ptr, char *dat);
void	page(struct client_data *ptr, char *dat);
void	ring(struct client_data *ptr, char *dat);
void	who(struct client_data *ptr, char *dat);

/** subr.c **/

void	init(int argc, char *argv[]);
void	assign_client(void);
void	delete_client(int cl_fd);
struct client_data *cl_addr(int num);   
void	ack(struct client_data *cl);
void	nak(struct client_data *cl);
void	log(int pri, char *fmt, ...);
void	snd_svmsg(int fd, char *fmt, ...);
void	flush_buf(int fd);
long	chatters(long chan);
int	ucheck(char *user, struct in_addr *uip);
void	usage(char *fmt, ...);
int	privileged(struct client_data *ud);
int	nick_ok(struct client_data *cl, char *nick);
char	*pr_time(time_t tim, int len);
