#!/bin/sh

inetd_conf_loc=/etc/inetd.conf
inetd_conf_svg=/etc/inetd.conf.before.ktalkd
tmpfile=/tmp/inetd.conf.tmp

PATH=$PATH:/opt/kde/bin:/usr/local/kde/bin:/usr/local/bin
PATH=$PATH:/opt/kde/sbin:/usr/local/kde/sbin:/usr/local/sbin

if [ ! -z "$KDEDIR" ]; then
    ktalkd_loc=$KDEDIR/bin/ktalkd
    kotalkd_loc=$KDEDIR/bin/kotalkd
else
    ktalkd_loc=`cd / && which ktalkd`
    kotalkd_loc=`echo $ktalkd_loc | sed -e 's/ktalkd/kotalkd/'`
fi

if [ ! -z "$ktalkd_loc" ]; then
    cp $inetd_conf_loc $inetd_conf_svg && \
    grep -v ^ntalk $inetd_conf_loc | grep -v ^talk | \
      grep -v kotalkd | grep -v ktalkd >$tmpfile && \
    cat >>$tmpfile <<EOF
# kotalkd
talk	dgram	udp	wait	root	/usr/sbin/tcpd	$kotalkd_loc
# ktalkd
ntalk	dgram	udp	wait	root	/usr/sbin/tcpd	$ktalkd_loc
EOF
    mv $tmpfile $inetd_conf_loc
    echo "Done. Now restart inetd with \"killall -HUP inetd\" for instance."
else
    echo "I can t find ktalkd. Please add its location to the PATH in this script."
fi

