## AC_FIND_USER_METHOD implemented here, 
## to avoid changing acinclude.m4.in (on Kulow's request)
## David Faure, faure@kde.org

AC_DEFUN(AC_FIND_USER_METHOD,
[ 
AC_MSG_CHECKING(ktalkd find_user method)
if test -n "`echo $target_os | grep linux`" ; then
    if test -d /proc; then
       AC_DEFINE(PROC_FIND_USER)

## Sufficient if all xdm and kdm would call sessreg to log the user into utmp
       AC_DEFINE(UTMP_AND_PROC_FIND_USER)

## Waiting for this, here is complement, looking for DISPLAY set in any process
## in /proc that the user owns
       AC_DEFINE(ALL_PROCESSES_AND_PROC_FIND_USER)

       AC_MSG_RESULT(using /proc.)
    else
       AC_MSG_RESULT(/proc not found, using utmp.)
    fi
else
    AC_MSG_RESULT(not a linux system, using utmp.)
fi

])

AC_DEFUN(AC_CHECK_UTMP,
[
AC_MSG_CHECKING([if it's safe to enable UTMP])

case "$host_os" in
linux*) utmp_support=yes;
     ;;
freebsd*) utmp_support=yes;
     ;;
*) utmp_support=no;
esac

AC_MSG_RESULT($utmp_support)

if test "$utmp_support" = yes; then
   AC_DEFINE_UNQUOTED(UTMP_SUPPORT)
fi  

AC_MSG_CHECKING([for utmp file])

AC_CACHE_VAL(kde_cv_utmp_file,
[
kde_cv_utmp_file=no

   for ac_file in     \
                      \
	/var/run/utmp \
	/var/adm/utmp \
	/etc/utmp \
     ; \
   do
     if test -r "$ac_file"; then
       kde_cv_utmp_file=$ac_file
       break
     fi
   done
])

AC_MSG_RESULT($kde_cv_utmp_file)
if test "$kde_cv_utmp_file" != "no"; then
  AC_DEFINE_UNQUOTED(UTMP, "$kde_cv_utmp_file")
fi

])
