#ifndef _TALKWIDGET_H_
#define _TALKWIDGET_H_

#include <qwidget.h>
#include <qsocknot.h>
#include <qlabel.h>
#include <qpushbt.h>
#include "simedit.h"
#include "connect.h"
#include "communication.h"
#include "keasybutton.h"

class TalkWidget : public QWidget {
  Q_OBJECT

public:
  enum StatusType {st_fresh, st_connecting, st_connected, 
                   st_mute, st_disconnected};

  TalkWidget (QWidget *parent=0, const char *name=0);
  ~TalkWidget ();
  void startConnection (const char* user);
  StatusType getStatus () {return status;}
  bool isNewerThan (int main, int sub, int subsub) {
    return (status == st_connected || status == st_mute) && 
           (doCommunication->compareKTalkVersion (main, sub, subsub) >= 0);
  }
  QString getName () {return strangerName->text ();}
  struct in_addr getDestIPAddr () {return doConnect->getDestIPAddr ();}

  void sendCommand (QString command, QString params);

signals:
  void message (const char *msg);
  void closeRequest (TalkWidget *widget);
  void newStatusRequest ();

  void receivedPingAckCommand (QString ID);

public slots:
  void setTalkFont (const QFont &font);
  void sendData (QString data);

protected:
  virtual void closeEvent (QCloseEvent *event);

private slots:
  void sendMessage (const char *msg);
  void closePressed ();
  void disconnectPressed ();

  void connectFailed (const char *msg);
  void connectSucceeded (int connectionSocket);

  void dataReceived (QString data);
  void disconnect (bool fromRemote);
  void nameChanged ();
  void commandReceived (QString command, QString params);

private:
  KEasyButton *close, *disconn;
  QString fullName;
  QLabel *strangerName;
  SimpleEdit *text;
  Connect *doConnect;
  Communication *doCommunication;
  StatusType status;
};

#endif
