#ifndef _TALKDLG_H_
#define _TALKDLG_H_

#include <qlabel.h>
#include <qlined.h>
#include <qdialog.h>
#include <qevent.h>
#include <qcombo.h>

#include "addrbook.h"
#include "keasybutton.h"

class TalkDialog: public QDialog {
  Q_OBJECT

public:
  TalkDialog ();
  ~TalkDialog () {}

  void execTalkDialog (AddressBook *adrBook);

signals:
  void startTalk (const char* toWhom);

private slots:
  void entrySelected (const char* entryID);
  void addressesSelected ();

private:
  QComboBox *cbTalk;
  QListBox *lbAdrBook, *lbAdrs;
  KEasyButton *pbTalk, *pbCancel;
  AddressBook *ab;  
};

#endif
