#include <qlayout.h>
#include <qevent.h>
#include <qaccel.h>
#include <kapp.h>
#include <kdebug.h>

#include "talkdlg.h"

TalkDialog::TalkDialog () : QDialog (0, 0, TRUE)
{
  cbTalk = new QComboBox (TRUE, this);
  cbTalk->setMinimumHeight(cbTalk->sizeHint().height());
  cbTalk->setInsertionPolicy (QComboBox::NoInsertion);
  QLabel *label1 = new QLabel (cbTalk, i18n ("&Talk to:"), this);
  label1->setMinimumSize (label1->sizeHint());

  lbAdrBook = new QListBox (this);
  lbAdrBook->setMinimumHeight (4 * lbAdrBook->itemHeight ());
  connect (lbAdrBook, SIGNAL (highlighted (const char *)), 
           SLOT (entrySelected (const char *)));
  QLabel *label2 = new QLabel (lbAdrBook, i18n ("Addressbook &Entries:"), 
                               this);
  label2->setMinimumSize (label2->sizeHint());

  lbAdrs = new QListBox (this);
  lbAdrs->setMultiSelection (TRUE);
  lbAdrs->setMinimumHeight (4 * lbAdrs->itemHeight ());
  connect (lbAdrs, SIGNAL (selectionChanged ()), SLOT (addressesSelected ()));
  QLabel *label3 = new QLabel (lbAdrs, i18n ("&Addresses:"), this);
  label3->setMinimumSize (label3->sizeHint());

  pbTalk = new KEasyButton (i18n ("Talk"), this, 0, -1, this, SLOT (accept ()),
                            i18n ("Establishes talk connection"));
  pbTalk->setDefault (TRUE);
  pbCancel = new KEasyButton (i18n ("Cancel"), this, 0, -1, 
                          this, SLOT (reject ()),
                          i18n ("Closes dialog without "
                                "establishing connection"));

  QBoxLayout *topLayout = new QVBoxLayout (this, 5);
  QBoxLayout *buttons = new QHBoxLayout ();

  topLayout->addWidget (label1);
  topLayout->addWidget (cbTalk);
  topLayout->addSpacing (20);
  topLayout->addWidget (label2);
  topLayout->addWidget (lbAdrBook, 10);
  topLayout->addSpacing (10);
  topLayout->addWidget (label3);
  topLayout->addWidget (lbAdrs, 10);
  topLayout->addLayout (buttons);

  buttons->addStretch (10);
  buttons->addWidget (pbTalk);
  buttons->addStretch (10);
  buttons->addWidget (pbCancel);
  buttons->addStretch (10);
  
  topLayout->activate ();

  resize (400, 400);
}

void TalkDialog::execTalkDialog (AddressBook *adrBook) {

  cbTalk->clear ();
  cbTalk->insertStrList (adrBook->getRecentList ());
  const QStrList *entryList = adrBook->getEntryList (); 
  lbAdrBook->clear ();
  lbAdrBook->insertStrList (entryList);
  lbAdrs->clear ();
  cbTalk->insertItem ("", 0);
  ab = adrBook;

  if (exec ()) {
    QStrList list = stripCommaList (cbTalk->currentText ());
    const char *a = list.first ();
    while (a) {
      emit startTalk (a);
      a = list.next ();
    }
  }
}

void TalkDialog::entrySelected (const char* entryID) {

  const QStrList *newAddresses = ab->getEntry (entryID);
  lbAdrs->clear ();
  if (newAddresses) {
    lbAdrs->insertStrList (newAddresses);
    if (newAddresses->count () == 1) {
      lbAdrs->setFocus ();             //workaround of bug in Qt
      lbAdrs->setSelected (0, TRUE);
      lbAdrBook->setFocus ();          //workaround of bug in Qt

      // bug in Qt 1.31: setSelected (int, bool) only works on an 
      //                 multiselectable QListBox, if it has focus
    }
  } else {
    KDEBUG1 (KDEBUG_ERROR, 3900,
             "Entry %s in Addressbook seems to have vanished!", entryID);
  }
}

void TalkDialog::addressesSelected () {

  uint i;
  QString commalist;
  for (i = 0; i < lbAdrs->count (); i++) {
    if (lbAdrs->isSelected (i)) {
      if (!commalist.isEmpty ())
        commalist.append (",");
      commalist.append (lbAdrs->text (i));
    }
  }
  cbTalk->changeItem (commalist, 0);
  cbTalk->setCurrentItem (0);
}
