#ifndef _SIMEDIT_H_
#define _SIMEDIT_H_

#include <stdlib.h>

#include <qmlined.h> 

class SimpleEdit : public QMultiLineEdit {
  Q_OBJECT
public:
  SimpleEdit (QWidget *parent = 0, const char *name = 0);

signals:
  void keyPressed (QString data);

public slots:
  void reset ();   // clears the edit widget
  void insertData (QString &data);    // insert data into the widget

protected:
//  virtual int insertKey (char ch);
  virtual void keyPressEvent (QKeyEvent *k);
  virtual void mousePressEvent (QMouseEvent *e);

private:
//  int processKey (char ch);
  QString translateKey (char ch);
  void appendText (QString s);  // appends the string to the edit window,
                                // using word wrap. s may not contain any
                                // control characters (like newline, bell, ...)
                                // except the tab key.

};

#endif
