// ping.h

// provides a window for presenting the results of the ping command

#ifndef _PING_H
#define _PING_H

#include <qlist.h>
#include <qstring.h>
#include <qlabel.h>
#include <qdatetm.h>
#include <qdialog.h>
#include "talkwidget.h"

class PingDialog : public QDialog {
  Q_OBJECT

public:
  PingDialog (QList <TalkWidget> &list);
  ~PingDialog () {};

private slots:
  void closeDialog ();
  void receiveAcknowledge (QString ID);

private:
  struct PingData {
    QLabel *label;
    QString stringID;
    QTime timer;
  };

  QList <struct PingData> pingList;
  static int pingID;
};

#endif
