// ping.cpp

#include <kapp.h>
#include <kmsgbox.h>
#include <qlayout.h>
#include "ping.h"

PingDialog::PingDialog (QList <TalkWidget> &list) :
   QDialog () {

  if (list.count () == 0) {
    KMsgBox::message (0, i18n ("Error"),
                      i18n ("There are no connections to "
                            "send ping commands to!"),
                      KMsgBox::EXCLAMATION);
    delete this;
    return;
  }
  setCaption (i18n ("Ping Results"));
  QVBoxLayout *topLayout = new QVBoxLayout (this, 10);
  QGridLayout *resultsLayout = new QGridLayout (list.count (), 3, 0);
  topLayout->addLayout (resultsLayout);
  resultsLayout->addColSpacing (1, 20);
  resultsLayout->setColStretch (0, 10);
  resultsLayout->setColStretch (2, 10);

  TalkWidget *help;
  unsigned int i;
  for (help = list.first (), i = 0; help; help = list.next (), i++) {
    PingData *pd = new PingData;
    pd->timer.start ();
    pd->stringID.setNum (pingID);
    pingID++;
    pd->label = new QLabel (i18n ("999.9 seconds"), this);
    pd->label->setMinimumSize (pd->label->sizeHint ());
    if (help->getStatus () != TalkWidget::st_connected && 
        help->getStatus () != TalkWidget::st_mute)
      pd->label->setText ("not connected");
    else if (!help->isNewerThan (0, 2, 7))
      pd->label->setText ("not supported");
    else {
      pd->label->setText ("running");
      connect (help, SIGNAL (receivedPingAckCommand (QString)),
                     SLOT (receiveAcknowledge (QString)));
      help->sendCommand ("PingReq", pd->stringID);
    }
    pd->label->setMinimumWidth (QMAX (pd->label->sizeHint ().width (),
                                      pd->label->minimumSize ().width ()));
    resultsLayout->addWidget (pd->label, i, 2);
    QLabel *name = new QLabel (help->getName (), this);
    name->setMinimumSize (name->sizeHint ());
    name->setAlignment (AlignRight);
    resultsLayout->addWidget (name, i, 0);
    pingList.append (pd);
  }
  KEasyButton *close = new KEasyButton (i18n ("Close"), this, 0, 60, this,
                                        SLOT (closeDialog ()));
  close->setFixedSize (close->minimumSize ());
  topLayout->addStretch (10);
  topLayout->addWidget (close);
  topLayout->activate ();
  this->setFixedSize (this->minimumSize ());
  this->show ();
}

void PingDialog::closeDialog () {
  delete this;
}

void PingDialog::receiveAcknowledge (QString ID) {
  struct PingData *help;
  for (help = pingList.first (); help; help = pingList.next ())
    if (help->stringID == ID) {
      QString value;
      value.sprintf (i18n ("%.1f seconds"), help->timer.elapsed () / 1000.0);
      help->label->setText (value);
    }
}

int PingDialog::pingID = 0;
