#ifndef _OPTIONS_H
#define _OPTIONS_H

// options.h

// Provides a class that handles the options menu and the config file stuff

#include <qobject.h>
#include <qstring.h>
#include <qfont.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <ksimpleconfig.h>

extern "C" {
#include <mediatool.h>
} 
#include <kaudio.h>

class Options: public QObject {
  Q_OBJECT

public:
  Options (QObject *parent = 0, const char *name = 0);
  ~Options ();

  void playAnnounceSound ();
  void setAutoExit (bool value) {exitONW = value;}

  enum TranslateType {OPT_notrans, OPT_westeurope, OPT_easteurope};

  bool getBeepOnConnect () {return beepOC;}
  bool getCloseOnDisconnect () {return closeOD;}
  bool getExitOnNoWindow () {return exitONW;}
  bool getSingleWindow () {return singleW;}

  bool getSendFullName () {return sendFN;}
  QString fullName () {return fn;}

  TranslateType getTranslate () {return translate;}
  QFont getTalkFont () {return talkFont;}
  QFont getMesgFont () {return mesgFont;}

  QString getFileSaveDir ();
  void setFileSaveDir (QString dir);
  QString getFileOpenDir ();
  void setFileOpenDir (QString dir);

signals:
  void mesgFontChanged (const QFont &font);
  void talkFontChanged (const QFont &font);
  void singleWindowChanged ();
  void fullNameChanged ();

public slots:
  void doDialog ();
  void okClicked ();
  void cancelClicked ();
  void selectMesgFont ();
  void selectTalkFont ();
  
private slots:
  void sendFNToggled (bool);
  void resetFN ();
  void browseSound ();
  void testSound ();
  void soundToggled ();

private:
  void createDialog ();
  void writeOptions ();
  bool playWAV (QString fileName);

  QDialog *d;
  QCheckBox *fnCheck;
  QComboBox *transCombo;
  QRadioButton *beepRadio;
  QCheckBox *singleWCheck, *beepOCCheck, *closeODCheck, *exitONWCheck;

  QLineEdit *fnLine, *soundLine;
  QPushButton *fnReset, *browseButton, *testSoundButton;
  QRadioButton *soundRadio;

  bool beepOC, closeOD, exitONW, singleW, sendFN, playS;
  QString fn, sf, unixName;
  TranslateType translate;
  QFont talkFont, mesgFont;

  KSimpleConfig *announceConf;
  KAudio *audio;
};

extern Options *options;

#endif
