#include <kapp.h>
#include <kdebug.h>
#include <qstrlist.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "ktalk.h"
#include "announcing.h"
#include "options.h"

int main( int argc, char **argv ) {

  int i;
  for (i = 1; i < argc; i++) {
    if (strcasecmp (argv [i], "--help") == 0) {
      printf ("USAGE:\n"
              "   ktalk [--autoexit] [user[@host][#tty]] ...\n"
              "   ktalk --help\n"
              "   ktalk --version\n"
              "You can specify several connections on the command line.\n"
              "Using the option \"--autoexit\", ktalk exits automatically "
              "after the last\nconnection is closed\n\n"
              "EXAMPLES:\n"
              "%% ktalk\n"
              "\tstart ktalk without initial connection\n"
              "%% ktalk heister Danny@rappl.aol.com\n"
              "\tstart ktalk and try to connect to heister on your local host\n"
              "\tand to Danny on host rappl.aol.com.\n\n"
              "REQUIREMENTS:\n"
              "   You need KDE Beta-2 or newer, Qt-1.31 or newer and\n"
              "   a running X-Server.\n");
      return 1;
    }
    if (strcasecmp (argv [i], "--version") == 0) {
      printf ("ktalk version " VERSION ", by Burkhard Lehner "
              "<b_lehner@informatik.uni-kl.de>\n");
      return 1;
    }
  }

  KApplication a (argc, argv);

  KDEBUG (KDEBUG_INFO, 3900,
          "Thank you for running ktalk, version " VERSION ".");
  if (initGlobalValues ())
    exit (1);
  options = new Options ();

  QStrList initial;
  for (i = 1; i < argc; i++)
    if (strncmp (argv [i], "--", 2) == 0) {
      if (strcasecmp (argv [i], "--autoexit") == 0)
        options->setAutoExit (TRUE);
      else
        KDEBUG1 (KDEBUG_WARN, 3900, "Unknown command line option \"%s\"",
                 argv [i]);
    } 
    else initial.append (argv [i]);

  AnnounceCenter *announce = new AnnounceCenter ();
  if (announce->startCenter (initial)) {
    KDEBUG (KDEBUG_INFO, 3900, "Another ktalk client is running. Exiting.");
    delete announce;
    delete options;
    return 0;
  }

  KTalk w (initial);
  w.resize (560, 500);
  a.setMainWidget (&w);
  QObject::connect (announce, SIGNAL (startTalk (const char*)),
                    &w, SLOT (talk (const char*)));
  w.show();
  int result = a.exec ();
  delete announce;
  delete options;
  return result;
}
