#ifndef _KTALK_H_
#define _KTALK_H_

#include <qlabel.h>
#include <qstrlist.h>
#include <qmlined.h>
#include <qdialog.h>
#include <knewpanner.h>
#include <kmenubar.h>
#include <ktmainwindow.h>
#include <kapp.h>

#include "addrbook.h"
#include "simedit.h"
#include "talkdlg.h"
#include "talkwidget.h"
#include "global.h"
#include "check_protocol.h"

class KDNDDropZone;

enum {P_File, P_Talk, P_Options, P_Help};

const int NR_OF_POPUPS = 4;

class MainWidget : public QWidget {
  Q_OBJECT
public:
  MainWidget (QWidget *parent=0, const char *name=0);
  ~MainWidget ();

  void setInteractiveMode (bool mode);

public slots:
  void setTalkFont (const QFont &font);

signals:
  void spreadData (QString data);
  void closeAllReq ();
  
private:
  SimpleEdit *talkText;
};

class MultiWidget : public QWidget {
  Q_OBJECT
public:
  MultiWidget (QWidget *parent = 0, const char *name = 0);
  ~MultiWidget () {};

  void setWidgets (QWidget *firstWidget, QList <TalkWidget> &otherWidgets);
  void setSingleWidget (QWidget *firstWidget);

protected:
  virtual void resizeEvent (QResizeEvent *);

private:
  void arrangeWidgets ();
  QList <QWidget> actualWidgets;
};

class KTalk : public KTMainWindow {
  Q_OBJECT
public:
  KTalk (QStrList &initial, QWidget *parent=0, const char *name=0);
  ~KTalk ();

signals:
  void setTalkFont (const QFont &font);

public slots:
  void printMessage (const char *msg);
  void talk (const char *stranger);

protected:
  virtual void closeEvent (QCloseEvent *) {
    KApplication::getKApplication ()->quit ();
  }

private slots:
  void talkDlg();
  void addrbook();

  void closeAll ();
  void doPing ();
  void doTransferFile ();
  void fileDropped (KDNDDropZone *zone);
  void closeTalk (TalkWidget *widget);
  void connectedStatusChanged ();
  void quit();
  void setMesgFont (const QFont &font);
  void toggleSingleWindow ();

  void protocolFound (ProtocolType protocol);
  void protocolTimeout ();

  void showMessages (int) {msgWindow->show ();}
  void hideMessages () {msgWindow->hide ();}

private:
  void reorganizeWindows ();

  QPopupMenu *popups[NR_OF_POPUPS];

  AddressBook *ab;
  TalkDialog *td;

  QList <TalkWidget> tw;
  bool atLeastOneConnected;

  MainWidget *myMainWidget;
  MultiWidget *myMultiWidget;
  QWidget *msgWindow;
  QMultiLineEdit *msgList;

  CheckProtocol *checker;
  QStrList initial_talks;

  int borderWidth, borderHeight;
};

#endif
