/*
 * @short Simple class for pushbuttons with minimum size set
 * @author Burkhard Lehner <b_lehner@informatik.uni-kl.de>
 * @version 1.0 (I think it is final, since it is such simple :-) )
 */

#include <qtooltip.h>
#include "keasybutton.h"

KEasyButton::KEasyButton (const char *text, QWidget *parent, const char *name,
                          int minimumWidth, QObject *receiver,
                          const char *member, const char *tooltip) :
   QPushButton (text, parent, name)
{
  QSize thisSize = sizeHint ();
  if (minimumWidth < -1)
    debug ("KEasyPushButton::KEasyPushButton (): argument minimumWidth "
           "must be non-negativ or -1");
  else if (minimumWidth == -1)
    thisSize.setWidth (QMAX (thisSize.width (), defaultMinimumWidth));
  else
    thisSize.setWidth (QMAX (thisSize.width (), minimumWidth));
  setMinimumSize (thisSize);
  if (receiver && member)
    connect (this, SIGNAL (clicked ()), receiver, member);
  if (tooltip)
    QToolTip::add (this, tooltip);   
}

void KEasyButton::setDefaultMinimumWidth (int width) {
  if (width < 0)
    debug ("KEasyPushButton::setDefaultMinimumWidth () must be called"
           " with a non-negative argument");
  else
    defaultMinimumWidth = width;
}

int KEasyButton::defaultMinimumWidth = 60;
