#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <sys/types.h>
#include <qstring.h>
#include "talkd.h"

int initGlobalValues ();
/* sets the global variables myMachineName, myLoginName,
   myMachineAddr, newTalkDemonPort, oldTalkDemonPort, and newDefaultMsg */

int checkKTalkMessage (char *message, int length, int &messageLength,
                       int &main, int &sub, int &subsub);
/* parses a message string that is used to identify another ktalk client.
   The message should have the form:
     ktalk {d}.{d}.{d}'\n'
   The initial "ktalk" string can have arbitrary case, {d} can be a string
   of digits one to four digits. Between "ktalk" and the first digit can be
   any number of whitespace characters (space or tab), and between the last
   digit and the ending '\n' can be any string. So the following identify
   strings are correct:
      "ktalk 0.0.0\n"
      "KTalk     1234.123.12 is the best program I've ever seen!\n"
      "KTALK9.8.7This is also correct\n"

   Parameters:
      message: Pointer to the string
      length: length of the string (does not have to be '\0' terminated) 
      messageLength: returns the length of the determined identifier string
                     (including the ending '\n')
      main, sub, subsub: return the found version numbers.
   return value:
      0: the found string is definitely NO ktalk identification string.
         messageLength has value 0, main, sub and subsub are undefined.
      1: the string presented so far can be an identification string.
         the values for messageLength, main, sub and subsub are undefined
      2: the string IS a ktalk identification string; messagLength, main,
         sub, subsub contain the correct values.
*/

enum ProtocolType {noProtocol, talkProtocol, ntalkProtocol};

extern QString localMachineName;        // name of local host
extern QString localLoginName;          // login name of local user
extern struct in_addr defaultReplyAddr; // network IP address of local machine
extern struct in_addr localhostAddr;    // IP address of "localhost" (127.0.0.1)
extern u_short talkDaemonPort;          // Port number of talk demon  (517)
extern u_short ntalkDaemonPort;         // Port number of ntalk demon (518)
extern ProtocolType localProtocol;      // protocol type on local machine

extern NEW_CTL_MSG newDefaultMsg;       // ntalk control message with defaults


#endif
