#include "global.h"
#include <netdb.h>
#include <unistd.h>
#include <pwd.h>
#include <strings.h>
#include <ctype.h>
#include <sys/utsname.h>
#include "check_protocol.h"
#include <kdebug.h>

QString localMachineName, localLoginName;
struct in_addr defaultReplyAddr, localhostAddr;
u_short ntalkDaemonPort, talkDaemonPort;
NEW_CTL_MSG newDefaultMsg;

ProtocolType localProtocol = noProtocol;  /* default: no protocol */

int initGlobalValues () {

  /* find the ntalk server's port */
  struct servent *sp = getservbyname("ntalk", "udp");
  if (!sp) {
    KDEBUG (KDEBUG_WARN, 3900,
            "Service ntalk/udp is not registered! "
            "(normally in '/etc/services') "
            "Using default port 518 instead!");
    ntalkDaemonPort = htons (518);
  } else
    ntalkDaemonPort = sp->s_port;
  
  /* find the talk server's port */
  sp = getservbyname("talk", "udp");
  if (!sp) {
    KDEBUG (KDEBUG_WARN, 3900,
            "Service talk/udp is not registered! "
            "(normally in '/etc/services') "
            "Using default port 517 instead!");
    talkDaemonPort = htons (517);
  } else
    talkDaemonPort = sp->s_port;

  /* get login name of local user */
  struct passwd *pw = getpwuid (getuid ());
  endpwent ();
  if (pw && strlen (pw->pw_name) > 0)
    localLoginName = pw->pw_name;
  else
    localLoginName = getlogin ();
  if (localLoginName.isEmpty ())
    KDEBUG (KDEBUG_FATAL, 3900, "Unable to get login name! You are unknown!");
  localLoginName.resize (NEW_NAME_SIZE);

  /* get local machine name */
  /* using 'uname' instead of 'gethostname', as suggested by Stephan Kulow */
  struct utsname buf;
  if (uname (&buf) == -1) {
    KDEBUG (KDEBUG_WARN, 3900,
            "Unable to get host name of your machine! Using 'localhost'");
    localMachineName = "localhost";
  }
  else localMachineName = buf.nodename;

/*
  char hostname [MAXHOSTNAMELEN];
  if (gethostname (hostname, MAXHOSTNAMELEN)) {
    KDEBUG (KDEBUG_FATAL, 3900, "Unable to get name of local host!");
    return -2;
  }
*/

  /* get IP address of local machine */
  struct hostent *hp = gethostbyname((const char *) localMachineName);
  if (!hp) {
    KDEBUG1 (KDEBUG_WARN, 3900,
            "Unable to get IP address of local host '%s'!\n"
            "Maybe communication with talk daemons isn't possible!",
            (const char *) localMachineName);
    // set it to INADDR_ANY and test it later
    defaultReplyAddr.s_addr = htonl (INADDR_ANY);
  } else
    memcpy (&defaultReplyAddr, hp->h_addr, hp->h_length);

  /* get IP address of "localhost" */
  localhostAddr.s_addr = htonl (127 << 24 + 1);  // default: 127.0.0.1
  hp = gethostbyname ("localhost");
  if (hp) 
    memcpy (&localhostAddr, hp->h_addr, hp->h_length);
  else {
    hp = gethostbyaddr ((const char *) &localhostAddr, sizeof (localhostAddr),
                        AF_INET);
    if (!hp) {
      // localhost doesn't seem to be installed on this system
      if (defaultReplyAddr.s_addr == htonl (INADDR_ANY)) {
        KDEBUG (KDEBUG_FATAL, 3900, 
                "Cannot find any host address of your local machine! "
                "Do you have TCP/IP installed? Using 127.0.0.1!");
      } else {
        KDEBUG1 (KDEBUG_WARN, 3900,
                "'localhost' (127.0.0.1) doesn't seem to be installed, "
                "using IP address of %s instead!",
                (const char *) localMachineName);
        localhostAddr = defaultReplyAddr;
      }
    } else
      KDEBUG1 (KDEBUG_WARN, 3900, 
               "Host with name 'localhost' doesn't exist, but seems to be "
               "installed at (127.0.0.1) with name %s!", hp->h_name);
  }
  if (defaultReplyAddr.s_addr == htonl (INADDR_ANY))
    defaultReplyAddr = localhostAddr;

  newDefaultMsg.vers = TALK_VERSION;
  newDefaultMsg.type = LOOK_UP;
  newDefaultMsg.id_num = htonl (0L);
  newDefaultMsg.addr.sin_family = htons (AF_INET);
  newDefaultMsg.ctl_addr.sin_family = htons (AF_INET);
  newDefaultMsg.pid = htonl (getpid ());
  strncpy (newDefaultMsg.l_name, localLoginName, NEW_NAME_SIZE);
  strncpy (newDefaultMsg.r_name, "ktalk", NEW_NAME_SIZE);
  newDefaultMsg.r_tty [0] = '\0';
  
  return 0;
}

static int getDigit (char *message, int length, int &position)
/* determines the value of the number at position "position" in string
   "message", which has the length "length".
   The number must have at least 1 digit, at most 4 digits.
   returns -1, if the first character is not a digit.
   otherwise returns the read value, is reading at most 4 digits, until
   it finds a non-digit character or reaches the end of the message.
   position is set to the index of the first non-digit, or the length of
   the message, if it's end is reached.
*/
{
  int value = 0;
  if (position >= length) return value;
  if (!isdigit (message [position])) return -1;

  for (int i = 0; i < 4 && position < length && isdigit (message [position]);
       i++, position++)
    value = value * 10 + (message [position] - '0');
  return value;
} 


int checkKTalkMessage (char *message, int length, int &messageLength,
                       int &main, int &sub, int &subsub)
{
  int position;
  messageLength = 0;
  if (length < 5) {
    if (strncasecmp (message, "ktalk", length) == 0)
      return 1;  /* maybe there is still more */
    else
      return 0;  /* doesn't start with "ktalk", so it's no ktalk string */
  }

  if (strncasecmp (message, "ktalk", 5))
    return 0;  /* doesn't start with "ktalk, so it's no ktalk string */

  for (position = 5; position < length && isspace (message [position]);
       position++);

  if ((main = getDigit (message, length, position)) == -1) return 0;
  if (position >= length) return 1;
  if (message [position++] != '.') return 0;

  if ((sub = getDigit (message, length, position)) == -1) return 0;
  if (position >= length) return 1;
  if (message [position++] != '.') return 0;

  if ((subsub = getDigit (message, length, position)) == -1) return 0;
  if (position >= length) return 1;

  while (position < length && message [position] != '\n')
    position++;
  if (position >= length)
    return 1;

  messageLength = position + 1;
  return 2;
}
