// filetransfer.h

// provides a class to enable file transfer via ktalk

#ifndef _FILETRANSFER_H
#define _FILETRANSFER_H

#include <qlist.h>
#include <qdialog.h>
#include <qfile.h>
#include <qlined.h>
#include <qcombo.h>
#include <ksock.h>
#include <kprogress.h>
#include "talkwidget.h"

class ProgressWidget;

class FileTransferSend : public QObject {
  Q_OBJECT

public:
  FileTransferSend (QList <TalkWidget> &list, const char *name = 0);
  ~FileTransferSend ();

private slots:
  void browse ();
  void abort ();
  void connected (KSocket *sock);
  void readyToWrite (KSocket *sock);

private:
  void doSend (TalkWidget *destination);
  void updateStatus ();

  QLineEdit *fileName;
  QComboBox *destinationCombo;

  QFile file;
  unsigned long fileSize, sendSize;
  KServerSocket *servSock;
  KSocket *sendSock;
  char writeBuffer [1024];
  int writeBufferLength;

  ProgressWidget *progressW;
};

class FileTransferReceive : public QObject {
  Q_OBJECT

public:
  FileTransferReceive (QString param, QString sender);
  ~FileTransferReceive ();

private slots:
  void browse ();
  void accepting ();
  void rejecting ();
  void abort ();
  void readyToRead (KSocket *sock);

private:
  QString cutUntilSemicolon (QString &rest);

  QString senderName, host;
  unsigned long port;
  QWidget *dialog;
  QLineEdit *fileName;

  QFile file;
  unsigned long fileSize, receiveSize;
  KSocket *receiveSock;

  ProgressWidget *progressW;
};

class ProgressWidget : public QWidget {
  Q_OBJECT

public:
  enum Direction {Receiving, Sending};
  ProgressWidget (Direction direction, QString file, QString partner,
                  int size);
  ~ProgressWidget () {}
  void updateValue (int value);

signals:
  void abort ();

protected:
  void closeEvent (QCloseEvent *event);

private:
  QLabel *statusLabel;
  KProgress *progressBar;
  int fileSize;
};

#endif
