/*
    daemon_socket.h

    Defines the class DaemonSocket, that handels a single DGRAM socket for
    communicating with a talk daemon (can be talk or ntalk protocol)

*/

#ifndef DAEMON_SOCKET_H
#define DAEMON_SOCKET_H

#include "talkd.h"
#include "global.h"
#include <qobject.h>
#include <qsocknot.h>
#include <qintdict.h>

class DaemonSocket : public QObject {
  Q_OBJECT

public:
  DaemonSocket (struct in_addr destiny, ProtocolType protocol,
                QObject *parent = 0, const char *name = 0);
  ~DaemonSocket ();

  bool success () {return ok;}
  struct in_addr getClientIP () {return clientAddr.sin_addr;}

signals:
  void receivedReply (NEW_CTL_RESPONSE answer);
  void timeout ();

public:
  bool send (NEW_CTL_MSG msg);
  bool sendReliable (NEW_CTL_MSG msg);

  static struct in_addr getReplyAddr (struct in_addr destination);

protected:
  virtual void timerEvent (QTimerEvent *);

private slots:
  void newPacketWaiting (int sock);

private:
  static QIntDict <in_addr> replyAddrList;

  QSocketNotifier *notify;
  struct sockaddr_in clientAddr, daemonAddr;
  NEW_CTL_MSG lastMessage;
  int retryCounter;
  ProtocolType proto;
  int sock;
  bool ok;
};

#endif
