/*
   connect.h

   Class definition for Connect, a class for building up a connection using the
   talk or ntalk protocol. The result is a socket that is connected to your
   talk partner.

*/

#ifndef CONNECT_H
#define CONNECT_H

#include "global.h"
#include "daemon_socket.h"
#include <qobject.h>
#include <qsocknot.h>
#include <qstring.h>

class Connect: public QObject {
Q_OBJECT

public:
  Connect (QObject *parent = 0, const char *name = 0);
  ~Connect ();

  bool establish (const char *address);
  const char* getUserName ();
  struct in_addr getDestIPAddr () {return remoteMachineAddr;}

signals:
  void statusMessage (const char *message);
  void failed (const char *message);
  void succeeded (int socket);
  void newUserName ();

protected:
  virtual void timerEvent (QTimerEvent *);

private slots:
  void checkProtocolTimeout ();
  void checkProtocolFound (ProtocolType type);

  void receivedLocalControl (NEW_CTL_RESPONSE rp);
  void receivedRemoteControl (NEW_CTL_RESPONSE rp);
  void receivedRemoteAnswer (int sockt);

  void daemonTimeout ();

private:
  enum StatusType {st_fresh, st_check_daemons, st_wait_LOOKUP_resp,
                   st_wait_INVITE_resp, st_wait_ANNOUNCE_resp, 
                   st_wait_for_connect, st_connected, st_failed};
  enum TargetType {ta_local, ta_remote};

  void cleanup ();
  void error (const char *message);
  bool sendDaemonReliable (TargetType target, NEW_CTL_MSG message);
  bool analyseUserAddress ();
  int openSocket (sockaddr_in *addr, int type);

  // timers
//  int daemonTimeoutID, reringTimeoutID;
//  int daemonTimeoutCounter, reringCounter;
  int reringTimeoutID;
  int reringCounter;

  StatusType status;
  QString user;   // name of user we are connecting to
  ProtocolType remoteProtocol;
  struct in_addr remoteMachineAddr;

  // sockets etc. for communication with daemons
  NEW_CTL_MSG daemonMessage;

  DaemonSocket *localSocket, *remoteSocket;

  int connectionSocket;
  struct sockaddr_in connectionSocketAddr;
  QSocketNotifier *connectionSocketNotify;

  // for sendDaemonReliable, to repeat the last message
  NEW_CTL_MSG last_msg;
  TargetType last_target;

  // message IDs to delete announcements and invitations
  int announceID, inviteID;
};

#endif
