/*
   communication.h

Defines the class "Communication", that controls the communication between
two talk clients on an already connected socket. It does:

1. exchange edit characters
2. send the ktalk identification string
3. receives and analyses the ktalk identification string
4. transfers characters and translates edit characters to local value
5. recognizes when the connection is destroyed

*/

#ifndef COMMUNICATION_H
#define COMMUNICATION_H

#include <qstring.h>
#include <qobject.h>
#include <qsocknot.h>
class FIFOBuffer;

class Communication : public QObject {
  Q_OBJECT

  public:
    Communication (QObject *parent = 0, const char *name = 0);
    ~Communication ();

    void startCommunication (int socket);

    enum ClientType {client_unknown, client_talk, client_ytalk, 
                     client_chitchat, client_ktalk};
    ClientType getTalkClient (int &main, int &sub, int &subsub);
    int compareKTalkVersion (int main, int sub, int subsub);

  signals:
    void connectionClosed (bool fromRemote);
    void dataReceived (QString data);
    void commandReceived (QString command, QString parameters);
    void clientTypeChanged ();

  public slots:
    void sendData (QString data);
    void sendData (const char *data, int length);
    void sendCommand (QString command, QString parameters);

  private slots:
    void incomingData (int streamSocket);
    void readyToSendData (int streamSocket);
    void sendFullNameCommand ();

  private:
    enum StatusType {st_editchars, st_welcome, st_normal, st_disconnected};

    void removeFromDataBuffer (int length);
    void cleanup ();

    StatusType status;
    int communicationSocket;
    QSocketNotifier *readNotify, *writeNotify;
    char myEditChars [3], hisEditChars [3];
    ClientType talkClient;
    int version_main, version_sub, version_subsub;
    FIFOBuffer *incoming, *outgoing;
};

#endif
