/* check_protocol.h */

#ifndef CHECK_PROTOCOL_H
#define CHECK_PROTOCOL_H

#include <qsocknot.h>
#include <qintdict.h>
#include "global.h"
#include "daemon_socket.h"

class CheckProtocol : public QObject {
  Q_OBJECT

public:
  CheckProtocol (QObject *parent=0, const char *name=0) :
     QObject (parent, name) {
    intern_protocol = noProtocol; 
    in_use = 0; 
    result_found = 0;
  }
  ~CheckProtocol () {}

  bool CheckHost (struct in_addr host);
  ProtocolType getProtocol () {return intern_protocol;}

signals:
  void timeout ();
  void found (ProtocolType protocol);

private slots:
  void talkReceived (NEW_CTL_RESPONSE msg);
  void ntalkReceived (NEW_CTL_RESPONSE msg);
  void noAnswer ();

private:
  in_addr hostAddr;
  DaemonSocket *talkSocket, *ntalkSocket;

  int /*retryCounter, retryMaximum,*/ in_use, result_found;
  ProtocolType intern_protocol;
  static QIntDict <ProtocolType> hostList;
  static ProtocolType old_talk_dummy;
  static ProtocolType new_talk_dummy;
};

#endif
