/* check_protocol.cpp */

/* routines to check which talk protocol (old talk or new talk) is installed
   on a host with a given IP address. Hosts which have already been tested
   are saved in a list so that the next request can be answered immediately.
 */

#include "check_protocol.h"
#include <config.h>
#include <unistd.h>
#include <string.h>
#include <kdebug.h>

#include <errno.h>

bool CheckProtocol::CheckHost (struct in_addr host) {

  /* CheckHost may only be called once! */
  if (in_use) return FALSE;
  in_use = 1;
  hostAddr = host;

  /* if host has been checked before... */
  if (hostList [(long) host.s_addr]) {
    intern_protocol = * (hostList [(long) host.s_addr]);
    emit found (intern_protocol);
    return TRUE;
  }

  /* create sockets */
  talkSocket = new DaemonSocket (host, talkProtocol, this);
  ntalkSocket = new DaemonSocket (host, ntalkProtocol, this);
  connect (talkSocket, SIGNAL (receivedReply (NEW_CTL_RESPONSE)),
                       SLOT (talkReceived (NEW_CTL_RESPONSE)));
  connect (talkSocket, SIGNAL (timeout ()), SLOT (noAnswer ()));
  connect (ntalkSocket, SIGNAL (receivedReply (NEW_CTL_RESPONSE)),
                        SLOT (ntalkReceived (NEW_CTL_RESPONSE)));
  connect (ntalkSocket, SIGNAL (timeout ()), SLOT (noAnswer ()));

  /* send control messages to daemons and return to caller */
  if (!talkSocket->sendReliable (newDefaultMsg) || 
      !ntalkSocket->sendReliable (newDefaultMsg)) {
    KDEBUG (KDEBUG_ERROR, 3900, 
           "CheckProtocol::CheckHost(): sendto() for talk or ntalk failed!");
    return FALSE;
  }
  return TRUE;
}

void CheckProtocol::noAnswer () {
  // As soon as one of the daemons reaches the timeout, the complete check
  // is stopped
  delete talkSocket;
  delete ntalkSocket;
  killTimers ();
  emit timeout ();
}

void CheckProtocol::talkReceived (NEW_CTL_RESPONSE resp) {
  ProtocolType *protocol;
  if (result_found) return;    // if one protocol was found, ignore others

  if (resp.type != LOOK_UP) return;
  protocol = &old_talk_dummy;

  result_found = 1;
  intern_protocol = talkProtocol;
  killTimers ();
  delete talkSocket;
  delete ntalkSocket;
  hostList.insert ((long) hostAddr.s_addr, protocol);
  emit found (intern_protocol);
}

void CheckProtocol::ntalkReceived (NEW_CTL_RESPONSE resp) {
  ProtocolType *protocol;
  if (result_found) return;    // if one protocol was found, ignore others

  if (resp.type != LOOK_UP) return;
  protocol = &new_talk_dummy;

  result_found = 1;
  intern_protocol = ntalkProtocol;
  killTimers ();
  delete talkSocket;
  delete ntalkSocket;
  hostList.insert ((long) hostAddr.s_addr, protocol);
  emit found (intern_protocol);
}

QIntDict <ProtocolType> CheckProtocol::hostList;
ProtocolType CheckProtocol::old_talk_dummy = talkProtocol;
ProtocolType CheckProtocol::new_talk_dummy = ntalkProtocol;
