#ifndef _ADDRBOOK_H_
#define _ADDRBOOK_H_

#include <stdlib.h>

#include <qpushbt.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qlined.h> 
#include <qmlined.h> 
#include <qstrlist.h>
#include <qdialog.h>
#include <qdict.h>
#include <ksimpleconfig.h>
#include "keasybutton.h"

QStrList stripCommaList (const QString &line);
QString buildCommaList (const QStrList &list);

class AddressBook : public QDialog {
  Q_OBJECT
public:
  AddressBook ();
  ~AddressBook () {delete abConfig; delete addrList; delete recentList;}

  const QStrList *getEntryList () {return &entries;}
  QStrList *getRecentList () {return recentList;}
  QStrList *getEntry (const char *entryID) {return (*addrList) [entryID];}
  QString *findAddress (const QString &adr);
  void insertRecentEntry (QString entry);
  
  void execAddressBook ();

private slots:
  void addEntry ();
  void changeEntry ();
  void delEntry ();
  void undelEntry ();
  void resetPressed ();
  void selectEntry (int i);

private:
  void readAddrConfig ();
  void writeAddrConfig ();
  void filloutDialog ();
  void buttonsForEntry ();

  KEasyButton *bAdd, *bChange, *bDelete, *bUndelete, *bClose, *bReset;

  QListBox *lbEntries;
  QMultiLineEdit *mleAddresses;

  int markedEntry;
  QStrIList entries;
  QStrList delEntries;

  KSimpleConfig *abConfig;
  QDict<QStrList> *addrList;
  QStrList *recentList;
};


class AddChangeDialog : public QDialog {
  Q_OBJECT

public:
  AddChangeDialog (const QStrList *usedEntries, const QStrList *recent, 
                   QWidget *parent = 0, const char *name = 0);
  AddChangeDialog (const QString entry, QStrList *addresses, 
                   const QStrList *usedEntries, const QStrList *recent, 
                   QWidget *parent = 0, const char *name = 0);
  ~AddChangeDialog () {}

  const char *getEntry () {return _entry->text ();}
  QStrList *getAddresses ();

private slots:
  void acceptPressed ();
  void recentSelected (const char *address);
  void entryReturnPressed ();

private:
  void fillDialog (bool change);
  QLineEdit *_entry;
  QListBox *_recent;
  QMultiLineEdit *_addresses;
  const QStrList *_usedEntries;
  QString oldEntry;
};


#endif
