/*
           panteltje uirc internet relay chat client
			with card_sharing  support

         Copyright (C) 1996-2002  Jan Mourer

 email: jan@panteltje.demon.nl
 snail mail:
 Jan Mourer
 Monnikebildtdijk 2
 9078 VE Oude Bildtzijl
 Holland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _UIRC_H_
#define _UIRC_H_

#define VERSION			"uirc-1.3"
#define DEFAULTPORT		6667
#define COMMANDCHAR		'/'
#define HISTORY_SIZE	40
#define SPEECH_COMMAND	"say -K 1.1 -t 15 -r 22000 -f 6"

/* colors / display control */
#define OFF             0
#define FLASH			5
#define INVERSE			7
#define BLACK			30
#define RED				31
#define GREEN			32
#define YELLOW			33
#define BLUE			34
#define MAGENTA			35
#define CYAN			36
#define WHITE			37
#define INTENSIFIED		37

#define BLACK_BG		40
#define RED_BG			41
#define GREEN_BG		42
#define YELLOW_BG		43
#define BLUE_BG			44
#define MAGENTA_BG		45
#define CYAN_BG			46
#define WHITE_BG_I		47
#define NORMAL_BG		48

/* for ignore */
#define NONE			0	/* default */
#define CTCP			1
#define PUBLIC			2	/* channel */
#define INVITES			4
#define NOTICES			8
#define MESSAGES		16
#define WALLOPS			32
#define NOTES			64 
#define ALL				65535

/* beep modes */
#define BEEP_NOT				0
#define BEEP_PRIVATE_MESSAGE	1

#include <termcap.h>
#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/un.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <pwd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>

int card_share_client_flag;

#endif
