// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widgetxms.h"
#include	"widgetfont.h"
#include	"widgetrendition.h"
#include	"afx.h"
#include	"afxtempl.h"

static const char rcsid[]="$Id: widgetxms.C,v 1.6 1999/04/09 02:32:28 mrsam Exp $";

////////////////////////////////////////////////////////////////////////

CXmString::CXmString() : m_ptr(NULL)
{
}

CXmString::~CXmString()
{
	Destroy();
}

CXmString & CXmString::operator=(XmString xms)
{
	if (xms)
	{
		xms=XmStringCopy(xms);
		if (!xms)	AfxThrowMemoryException();
	}
	Destroy();
	if ((m_ptr=new CXmStringData) == NULL)
		AfxThrowMemoryException();
	m_ptr->m_refcnt=1;
	m_ptr->m_str=xms;
	return (*this);
}

CXmString & CXmString::operator=(CString str)
{
XmString xms=XmStringCreateLocalized("");
XmString newxm=NULL;

	if (!xms)	AfxThrowMemoryException();

	try
	{
		while (str.GetLength())
		{
		int	i=str.Find('\n');
		XmString xmnew;

			if (i < 0)	i=str.GetLength();

			if (i == 0)
			{
				newxm=XmStringSeparatorCreate();
				str=str.Mid(1);
			}
			else
			{
				newxm=XmStringCreateLocalized(
					(char *)(const char *)str.Left(i));
				str=str.Mid(i);
			}

			if (!newxm)
				AfxThrowMemoryException();

			xmnew=XmStringConcat(xms, newxm);
			if (!xmnew)
				AfxThrowMemoryException();
			XmStringFree(newxm);
			newxm=NULL;
			XmStringFree(xms);
			xms=xmnew;
		}
	}
	catch (...)
	{
		if (newxm)
			XmStringFree(newxm);
		XmStringFree(xms);
		throw;
	}
	Destroy();
	if ((m_ptr=new CXmStringData) == NULL)
		AfxThrowMemoryException();
	m_ptr->m_refcnt=1;
	m_ptr->m_str=xms;
	return (*this);
}

CXmString::operator	CString() const
{
CString	str="";
CXmStringContext context;

	if (xmptr() == NULL || !context.Start(xmptr()))	return (str);

XmStringComponentType type;

	while ((type=context.Next()) != XmSTRING_COMPONENT_END)
	{
		switch (type)	{
		case XmSTRING_COMPONENT_SEPARATOR:
			str += '\n';
			break;
		case XmSTRING_COMPONENT_TAB:
			str += '\t';
			break;
		case XmSTRING_COMPONENT_LOCALE_TEXT:
			str += context.Val();
			break;
		case XmSTRING_COMPONENT_WIDECHAR_TEXT:
			break;	// Not yet
		case XmSTRING_COMPONENT_TEXT:
			str += context.Val();
			break;
		}
	}
	return (str);
}

void CXmString::Rendition(CString s)
{
	Rendition((const char *)s);
}

void CXmString::Rendition(const char * s)
{
	if (xmptr())
	{
	XmString	newstr=XmStringPutRendition(xmptr(), (String)s);

		if (!newstr)	AfxThrowMemoryException();
		try
		{
			operator=(newstr);
			XmStringFree(newstr);
		}
		catch (...)
		{
			XmStringFree(newstr);
			throw;
		}
	}
}

CXmString &CXmString::operator += (XmString xms)
{
	if (!xms)
		return (*this);
	if (!xmptr())
	{
		operator=(xms);
		return (*this);
	}

	xms=XmStringConcat(xmptr(), xms);
	if (!xms)
		AfxThrowMemoryException();

	try
	{
		operator=(xms);
		XmStringFree(xms);
	}
	catch (...)
	{
		XmStringFree(xms);
		throw;
	}
	return (*this);
}

CXmString CXmString::operator + (XmString xms) const
{
CXmString s;

	s=xmptr();
	s += xms;
	return (s);
}

/////////////////////////////////////////////////////////////////
//
// Extract renditions from a string

void	CXmStringRenditions::operator=(const CXmString &xms)
{
CXmStringContext context;
XmStringComponentType next_element;
CString	current_rendition="";

	m_strings.RemoveAll();
	m_renditions.RemoveAll();
	m_stack.RemoveAll();

XmString	xms_val=xms;

	if (!xms_val)	return;	// That was easy!

	context.Start((XmString)xms);

CString	s;
unsigned	charcnt=0;

	while ((next_element=context.Next()) != XmSTRING_COMPONENT_END)
	{
		switch (next_element)	{
		case XmSTRING_COMPONENT_SEPARATOR:
			s="\n";
			break;
		case XmSTRING_COMPONENT_TAB:
			{
			size_t	n= (8- (charcnt % 8));

				s=CString(' ', n);
			}
			break;
		case XmSTRING_COMPONENT_LOCALE_TEXT:
		case XmSTRING_COMPONENT_TEXT:
			s=context.Val();
			break;
		case XmSTRING_COMPONENT_RENDITION_BEGIN:
			m_stack.AddHead(current_rendition);
			current_rendition=context.Val();
			continue;
		case XmSTRING_COMPONENT_RENDITION_END:
			if (!m_stack.IsEmpty())
				current_rendition=
					m_stack.RemoveHead();
			continue;
		default:
			continue;
		}

		// See if we can optimize things a bit

		if (*(const char *)s != '\n' && !m_strings.IsEmpty() &&
			m_renditions.GetTail() == current_rendition)
		{
			m_strings.GetTail() += s;
		}
		else
		{
			m_strings.AddTail(s);
			m_renditions.AddTail(current_rendition);
		}
		if ( *(const char *)s == '\n')
			charcnt=0;
		else
			charcnt += s.GetLength();
	}
}

///////////////////////////////////////////////////////////////
//
// Get renditions for a CXmString

void	CXmStringMetrics::Measure(CWidget &w, XmRenderTable r,
			CXmStringRenditions &sr)
{
POSITION strPos, rendPos;
size_t	xmLength;

	// Add up # of characters

	for (xmLength=0, strPos=sr.m_strings.GetHeadPosition(); strPos; )
		xmLength += sr.m_strings.GetNext(strPos).GetLength();

	m_metrics.SetSize(xmLength);

size_t	startingIdx;	// Current index into m_metrics;
int	startingXpos; // Current starting x position in m_metrics

	startingIdx=0;
	startingXpos=0;

CString	theRendition;
CXFontSet xfs;
CXmRendition xmr;
XRectangle *mtrPtr=m_metrics.GetData();

	for (strPos=sr.m_strings.GetHeadPosition(),
		rendPos=sr.m_renditions.GetHeadPosition(); strPos; )
	{
	CString &theString=sr.m_strings.GetNext(strPos);
		// Required, due to XmbTextPerCharExtents hack below

		theRendition=sr.m_renditions.GetNext(rendPos);

	size_t	sLength=theString.GetLength();
	size_t	i;

		xmr.Extract(r, theRendition);
		if (xfs.Create(w, xmr.FontName()))
		{
		size_t	stringLen, auxLen;

			// For some reason, XmbTextPerCharExtents will
			// not fill in default metrics for invalid character,
			// as RTFM sez, so we must compensate by deleting
			// those invalid characters.

			for (;;)
			{
				xfs.TextMetrics(m_aux, theString);
				auxLen=m_aux.GetSize();
				stringLen=theString.GetLength();
				if (auxLen >= stringLen)	break;

				theString=theString.Left(auxLen) +
					theString.Mid(auxLen+1);
			}

			if (auxLen > stringLen)	AfxThrowInternalException();

		XRectangle *auxPtr=m_aux.GetData();

			for (i=0; i<sLength; i++)
			{
				mtrPtr->x= auxPtr->x + startingXpos;
				mtrPtr->y= auxPtr->y;
				mtrPtr->width= auxPtr->width;
				mtrPtr->height= auxPtr->height;
				++mtrPtr;
				++auxPtr;
				++startingIdx;
			}
			if (startingIdx)
			{
				startingXpos= mtrPtr[-1].x;
				if (mtrPtr[-1].width > 0)
					startingXpos += mtrPtr[-1].width;
			}
		}
	}
	m_metrics.SetSize(startingIdx);
}

//	Wordwrap a string to a given width

void CXmStringWordWrap::WordWrap(CXmStringRenditions &renditions,
			CXmStringMetrics &metrics,
			size_t toWidth,
			CList<CXmString, CXmString &> &list)
{
	list.RemoveAll();	// That's for starters...

CXmStringMetricIterator	iterator;

	iterator.Start(renditions);

	while (!iterator.EOL())
	{
	AFXBOOL			foundSpace=FALSE;
	CXmStringMetricIterator spacePos;
	CXmStringMetricIterator start;
	size_t	curWidth=0;

		start=iterator;	// Save starting position

		for (;;)
		{
		const char * ch= iterator.m_chptr;

			if (iterator.EOL() || *ch == ' ' || *ch == '\n')
			{
				if (curWidth > toWidth && foundSpace)	break;
					// Go back to previous space.

				spacePos=iterator;
				foundSpace=TRUE;
				if (iterator.EOL() || *ch == '\n'
						|| curWidth > toWidth)	break;
			}
			curWidth += metrics.m_metrics[iterator.m_metricIndex]
					.width;
			if (curWidth > toWidth && foundSpace)
				break;
			iterator.Next();
		}

		if (!foundSpace)	// If there were no spaces, break at
					// EOL (end of line)
			spacePos=iterator;
		else
		{
			// Add all spaces we can.

			while (!spacePos.EOL() && *spacePos.m_chptr == ' ')
				spacePos.Next();
			iterator=spacePos;	// Resume here
			if (!iterator.EOL() && *iterator.m_chptr == '\n')
				iterator.Next(); // ...on the next line, that is
		}

		// We know where we want to break, so break it.

	size_t	charsToDo= spacePos.m_metricIndex - start.m_metricIndex;
	CXmString	curString;

		while (charsToDo)
		{
		size_t	nChars= start.m_curString.GetLength() -
					start.m_curStringPos;
		CXmString	new_string;

			if (nChars > charsToDo)	nChars=charsToDo;
			new_string=start.m_curString.Mid(start.m_curStringPos,
							nChars);
			new_string.Rendition(start.m_curRendition);
			curString += new_string;
			charsToDo -= nChars;
			start.Advance();
		}
		list.AddTail(curString);
	}
}
////////////////////////////////////////////////////////////////////////

void	CXmStringMetricIterator::Start(CXmStringRenditions &r)
{
	m_renditions= &r;

	m_stringPos=m_renditions->m_strings.GetHeadPosition();
	m_rendPos=m_renditions->m_renditions.GetHeadPosition();
	m_curString="";
	m_curRendition=m_curString;

	if (m_stringPos)
	{
		m_curString=m_renditions->m_strings.GetAt(m_stringPos);
		m_curRendition=m_renditions->m_strings.GetAt(m_rendPos);
	}
	m_metricIndex=0;
	m_curStringPos=0;
	m_chptr=m_curString;
	if (m_curString.GetLength() == 0 && m_stringPos)	Advance();
					// Empty strings - skip them
}

void	CXmStringMetricIterator::Advance()
{
	do
	{
		m_renditions->m_strings.GetNext(m_stringPos);
		m_renditions->m_renditions.GetNext(m_rendPos);

		if (m_stringPos)
		{
			m_curString=m_renditions->m_strings
					.GetAt(m_stringPos);
			m_curRendition=m_renditions
					->m_renditions.GetAt(m_rendPos);
		}
		m_curStringPos=0;
		m_chptr=m_curString;
	} while (m_stringPos && m_curString.GetLength() == 0);
}

////////////////////////////////////////////////////////////////////////

CXmStringContext::~CXmStringContext()
{
	Destroy();
}

void CXmStringContext::Destroy()
{
	if (context)
	{
		XmStringFreeContext(context);
		context=NULL;
	}
}

AFXBOOL CXmStringContext::Start(XmString xms)
{
	return (XmStringInitContext(&context, xms) ? TRUE:FALSE);
}


XmStringComponentType CXmStringContext::Next()
{
	if (!context)
		return (XmSTRING_COMPONENT_END);

XtPointer	p;
XmStringComponentType t=XmStringGetNextTriple(context, &len, &p);

	val=p && len ? CString((char *)p, len):CString("");
	if (p)	XtFree((char *)p);
	return (t);
}
