// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	input_h
#define	input_h

static const char input_h_rcsid[]="$Id: widgettimer.h,v 1.7 1999/04/09 02:32:28 mrsam Exp $";


#include	<X11/Intrinsic.h>
#include	<unistd.h>
#include	"afx.h"

#include	"widget.h"
#include	"widgetapp.h"

class CApplicationWidget;

/////////////////////////////////////////////////////////////////////////
//
// Similarly ncapsulate Xt timeouts

template<class T> class CXmTimeout {

	T	*m_instance;

	void	(T::*m_function)();
public:
	CXmTimeout(T *w=(T *)NULL) : m_instance(w),
				m_function( (void (T::*)()) NULL)	{}
	void operator=(T *p) { m_instance=p; }
	virtual ~CXmTimeout();

	// There is no copy construction, really, but we need a copy
	// constructor in order to be able to keep a list of these things

	CXmTimeout(const CXmTimeout &t) : m_instance(t.m_instance),
				m_function( (void (T::*)()) NULL)	{}

	CXmTimeout &operator=(const CXmTimeout &) {}

private:
	XtIntervalId	m_id;

static	void	timer_proc(CXmTimeout *, XtIntervalId *);
protected:
	void	TimerFunc();
public:
	AFXBOOL	Armed() { return (!!m_function); }

	void	Arm(void (T::*p)(), unsigned n) { Arm_ms(p, n * 1000); }
	void	Arm_ms(void (T::*p)(), unsigned long t)
		{
			Cancel();

			m_id=XtAppAddTimeOut( CApplicationWidget::Context(),
						t, &timer_proc, this);
			m_function=p;
		}
	void	Cancel()
		{
			if (m_function)
			{
				XtRemoveTimeOut(m_id);
				m_function=(void (T::*)()) NULL;
			}
		}
} ;

/////////////////////////////////////////////////////////////////////////
//
// Sometimes we want to do something, but wait until we return to the
// Xt main loop before doing so.  A timeout of zero seconds accomplishes
// this function quite nicely.

template<class T> class CEvent : public CXmTimeout<T> {
public:
	CEvent(T *w=(T *)NULL) : CXmTimeout<T>(w)	{}
	~CEvent()					{}
	void operator=(T *p) { CXmTimeout<T>::operator=(p); }

	void Arm(void (T::*p)() ) { CXmTimeout<T>::Arm_ms(p, 0); }
} ;

template<class T> CXmTimeout<T>::~CXmTimeout()
{
	Cancel();
}

template<class T> void CXmTimeout<T>::timer_proc(CXmTimeout *p, XtIntervalId *)
{
	p->TimerFunc();
}

template<class T> void CXmTimeout<T>::TimerFunc()
{
void	(T::*p)()=m_function;

	m_function=0;
	(m_instance->*p)();
}
#endif
